/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.catalina;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;
import org.jboss.modcluster.JvmRouteFactory;
import org.jboss.modcluster.ModClusterService;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.modcluster.Strings;
import org.jboss.modcluster.catalina.CatalinaEventHandlerAdapter;
import org.jboss.modcluster.config.LoadConfiguration;
import org.jboss.modcluster.config.ModClusterConfig;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.LoadBalanceFactorProviderFactory;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProvider;
import org.jboss.modcluster.load.metric.LoadContext;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.modcluster.load.metric.impl.BusyConnectorsLoadMetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModClusterListener
extends ModClusterConfig
implements LifecycleListener,
LoadConfiguration,
LoadBalanceFactorProviderFactory,
ModClusterServiceMBean {
    private static final Logger log;
    private final ModClusterServiceMBean service;
    private final LifecycleListener listener;
    private Class<? extends LoadMetric<? extends LoadContext>> loadMetricClass = BusyConnectorsLoadMetric.class;
    private int decayFactor = 2;
    private int history = 9;
    private double capacity = 1.0;

    public ModClusterListener() {
        ModClusterService service = new ModClusterService((ModClusterConfig)this, this);
        this.service = service;
        this.listener = new CatalinaEventHandlerAdapter(service);
    }

    protected ModClusterListener(ModClusterServiceMBean mbean, LifecycleListener listener) {
        this.service = mbean;
        this.listener = listener;
    }

    @Override
    public LoadBalanceFactorProvider createLoadBalanceFactorProvider() {
        try {
            LoadMetric<? extends LoadContext> metric = this.loadMetricClass.newInstance();
            metric.setCapacity(this.capacity);
            DynamicLoadBalanceFactorProvider provider = new DynamicLoadBalanceFactorProvider(Collections.singleton(metric));
            provider.setDecayFactor(this.decayFactor);
            provider.setHistory(this.history);
            return provider;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        this.listener.lifecycleEvent(event);
        Lifecycle source = event.getLifecycle();
        if (source instanceof Server) {
            Server server = (Server)source;
            String type = event.getType();
            if ("after_start".equals(type)) {
                try {
                    ObjectName name = this.getObjectName(server);
                    Registry.getRegistry(null, null).registerComponent((Object)this, name, null);
                }
                catch (Exception e) {
                    log.error((Object)Strings.ERROR_JMX_REGISTER.getString(new Object[0]), (Throwable)e);
                }
            } else if ("stop".equals(type)) {
                try {
                    ObjectName name = this.getObjectName(server);
                    Registry.getRegistry(null, null).unregisterComponent(name);
                }
                catch (Exception e) {
                    log.error((Object)Strings.ERROR_JMX_UNREGISTER.getString(new Object[0]), (Throwable)e);
                }
            }
        }
    }

    private ObjectName getObjectName(Server server) throws MalformedObjectNameException {
        String domain = (String)IntrospectionUtils.getProperty((Object)server, (String)"domain");
        return ObjectName.getInstance(domain, "type", "ModClusterListener");
    }

    public Class<? extends JvmRouteFactory> getJvmRouteFactoryClass() {
        return this.getJvmRouteFactory().getClass();
    }

    public void setJvmRouteFactoryClass(Class<? extends JvmRouteFactory> factoryClass) throws InstantiationException, IllegalAccessException {
        this.setJvmRouteFactory(factoryClass.newInstance());
    }

    @Override
    public Class<? extends LoadMetric<? extends LoadContext>> getLoadMetricClass() {
        return this.loadMetricClass;
    }

    public void setLoadMetricClass(Class<? extends LoadMetric<? extends LoadContext>> loadMetricClass) {
        this.loadMetricClass = loadMetricClass;
    }

    @Override
    public int getLoadDecayFactor() {
        return this.decayFactor;
    }

    public void setLoadDecayFactor(int decayFactor) {
        this.decayFactor = decayFactor;
    }

    @Override
    public int getLoadHistory() {
        return this.history;
    }

    public void setLoadHistory(int history) {
        this.history = history;
    }

    @Override
    public double getLoadMetricCapacity() {
        return this.capacity;
    }

    public void setLoadMetricCapacity(double capacity) {
        this.capacity = capacity;
    }

    @Override
    public void addProxy(String host, int port) {
        this.service.addProxy(host, port);
    }

    @Override
    public boolean disable() {
        return this.service.disable();
    }

    @Override
    public boolean disableContext(String hostName, String contextPath) {
        return this.service.disableContext(hostName, contextPath);
    }

    @Override
    public Map<InetSocketAddress, String> ping() {
        return this.service.ping();
    }

    @Override
    public Map<InetSocketAddress, String> ping(String jvmRoute) {
        return this.service.ping(jvmRoute);
    }

    @Override
    public Map<InetSocketAddress, String> ping(String scheme, String host, int port) {
        return this.service.ping(scheme, host, port);
    }

    @Override
    public boolean enable() {
        return this.service.enable();
    }

    @Override
    public boolean enableContext(String hostName, String contextPath) {
        return this.service.enableContext(hostName, contextPath);
    }

    @Override
    public Map<InetSocketAddress, String> getProxyConfiguration() {
        return this.service.getProxyConfiguration();
    }

    @Override
    public Map<InetSocketAddress, String> getProxyInfo() {
        return this.service.getProxyInfo();
    }

    @Override
    public void refresh() {
        this.service.refresh();
    }

    @Override
    public void removeProxy(String host, int port) {
        this.service.removeProxy(host, port);
    }

    @Override
    public void reset() {
        this.service.reset();
    }

    @Override
    public boolean stop(long timeout, TimeUnit unit) {
        return this.service.stop(timeout, unit);
    }

    @Override
    public boolean stopContext(String host, String path, long timeout, TimeUnit unit) {
        return this.service.stopContext(host, path, timeout, unit);
    }

    static {
        if (Logger.getPluginClassName() == null) {
            String pluginClass = "org.jboss.logging.jdk.JDK14LoggerPlugin";
            try {
                ModClusterListener.class.getClassLoader().loadClass(pluginClass);
                Logger.setPluginClassName((String)pluginClass);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        log = Logger.getLogger(ModClusterListener.class);
    }
}

