/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.vendor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;

public class MSSQLValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static transient Logger log;
    private static final String SQLSERVER_CONNECTION_CLASS = "com.microsoft.sqlserver.jdbc.SQLServerConnection";
    private static final String VALIDATION_SQL_QUERY = "SELECT 1";
    private transient boolean driverHasIsValidMethod;
    private transient Method isValid;
    private static Object[] timeoutParam;
    private static final long serialVersionUID = 4609709370615627138L;

    public MSSQLValidConnectionChecker() {
        this.initIsValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLException isValidConnection(Connection c) {
        block30: {
            if (this.driverHasIsValidMethod) {
                try {
                    Boolean valid = (Boolean)this.isValid.invoke((Object)c, timeoutParam);
                    if (!valid.booleanValue()) {
                        return new SQLException("Connection is unvalid or " + timeoutParam[0] + " sec timeout has expired");
                    }
                    break block30;
                }
                catch (Exception e) {
                    if (e instanceof SQLException) {
                        return (SQLException)e;
                    }
                    log.warn((Object)"Unexpected error in isValid() method", (Throwable)e);
                    return new SQLException("isValid() method failed: " + e.toString());
                }
            }
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = c.createStatement();
                rs = stmt.executeQuery(VALIDATION_SQL_QUERY);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    SQLException sQLException = (SQLException)e;
                    return sQLException;
                }
                log.warn((Object)"Unexpected error in 'SELECT 1'", (Throwable)e);
                SQLException sQLException = new SQLException("'SELECT 1' failed: " + e.toString());
                return sQLException;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ignore) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ignore) {}
            }
        }
        return null;
    }

    private void initIsValid() {
        block5: {
            log = Logger.getLogger(this.getClass());
            this.driverHasIsValidMethod = false;
            try {
                Class<?> connectionClazz = Thread.currentThread().getContextClassLoader().loadClass(SQLSERVER_CONNECTION_CLASS);
                this.isValid = connectionClazz.getMethod("isValid", Integer.TYPE);
                if (this.isValid != null && !Modifier.isAbstract(this.isValid.getModifiers())) {
                    this.driverHasIsValidMethod = true;
                }
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Cannot resolve com.microsoft.sqlserver.jdbc.SQLServerConnection class. Wrong ValidConnectionChecker is configured? Will use 'SELECT 1' instead.", (Throwable)e);
            }
            catch (SecurityException e) {
                log.error((Object)"Cannot access com.microsoft.sqlserver.jdbc.SQLServerConnection.isValid() Will use 'SELECT 1' instead.", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"Cannot resolve isValid() method for com.microsoft.sqlserver.jdbc.SQLServerConnection class (JDBC driver 2.0+). Will use 'SELECT 1' instead (JDBC driver 1.2 and earlier).");
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.initIsValid();
    }

    static {
        timeoutParam = new Object[]{1};
    }
}

