/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server;

import javax.management.MBeanServerBuilder;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.util.Classes;

public abstract class ServerConfig {
    private static ServerConfig instance;
    private static final String JMI_DOMAIN = "JMImplementation";
    private static final String DEFAULT_DOMAIN = "DefaultDomain";
    private static final ObjectName mbeanServerDelegateName;
    public static final String SERVER_CONFIG_CLASS_PROPERTY = "jbossmx.server.config.class";
    public static final String DEFAULT_SERVER_CONFIG_CLASS = "org.jboss.mx.server.JBossMXServerConfig";
    public static final String MBEAN_SERVER_BUILDER_CLASS_PROPERTY = "javax.management.builder.initial";

    public static synchronized ServerConfig getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = (ServerConfig)Classes.instantiate(ServerConfig.class, (String)SERVER_CONFIG_CLASS_PROPERTY, (String)DEFAULT_SERVER_CONFIG_CLASS);
        return instance;
    }

    protected ServerConfig() {
    }

    public String getDefaultDomain() {
        return DEFAULT_DOMAIN;
    }

    public String getJMIDomain() {
        return JMI_DOMAIN;
    }

    public ObjectName getMBeanServerDelegateName() {
        return mbeanServerDelegateName;
    }

    public MBeanServerBuilder getMBeanServerBuilder() {
        String defaultMBeanServerBuilder = this.getDefaultMBeanServerBuilderClassName();
        return (MBeanServerBuilder)Classes.instantiate(MBeanServerBuilder.class, (String)MBEAN_SERVER_BUILDER_CLASS_PROPERTY, (String)defaultMBeanServerBuilder);
    }

    public abstract ObjectName getLoaderRepositoryName();

    protected abstract String getDefaultMBeanServerBuilderClassName();

    static {
        mbeanServerDelegateName = ObjectNameFactory.create((String)"JMImplementation:type=MBeanServerDelegate");
    }
}

