/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.protocol;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jboss.vfs.VFSUtils;

public abstract class AbstractURLConnection
extends URLConnection {
    private String contentType;

    protected AbstractURLConnection(URL url) {
        super(url);
    }

    @Override
    public String getHeaderField(String name) {
        String headerField = null;
        if (name.equals("content-type")) {
            headerField = this.getContentType();
        } else if (name.equals("content-length")) {
            headerField = String.valueOf(this.getContentLength());
        } else if (name.equals("last-modified")) {
            long lastModified = this.getLastModified();
            if (lastModified != 0L) {
                Date modifiedDate = new Date(lastModified);
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                headerField = sdf.format(modifiedDate);
            }
        } else {
            headerField = super.getHeaderField(name);
        }
        return headerField;
    }

    @Override
    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = AbstractURLConnection.getFileNameMap().getContentTypeFor(this.getName());
        if (this.contentType == null) {
            try {
                InputStream is = this.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(is);
                this.contentType = URLConnection.guessContentTypeFromStream(bis);
                bis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.contentType;
    }

    protected static URI toURI(URL url) throws IOException {
        try {
            return VFSUtils.toURI(url);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected abstract String getName();
}

