/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.lang.reflect.Method;
import java.net.URI;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.ClientInterceptorRepositoryImpl;
import org.jboss.resteasy.client.core.extractors.ClientErrorHandler;
import org.jboss.resteasy.client.core.extractors.ClientRequestContext;
import org.jboss.resteasy.client.core.extractors.EntityExtractor;
import org.jboss.resteasy.client.core.extractors.EntityExtractorFactory;
import org.jboss.resteasy.client.core.marshallers.ClientMarshallerFactory;
import org.jboss.resteasy.client.core.marshallers.Marshaller;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.MediaTypeHelper;

public class ClientInvoker
extends ClientInterceptorRepositoryImpl {
    protected ResteasyProviderFactory providerFactory;
    protected String httpMethod;
    protected UriBuilderImpl uri;
    protected Method method;
    protected Class declaring;
    protected MediaType accepts;
    protected Marshaller[] marshallers;
    protected ClientExecutor executor;
    protected boolean followRedirects;
    protected EntityExtractor extractor;
    protected EntityExtractorFactory extractorFactory;
    protected URI baseUri;

    public ClientInvoker(URI baseUri, Class declaring, Method method, ResteasyProviderFactory providerFactory, ClientExecutor executor, EntityExtractorFactory extractorFactory) {
        this.declaring = declaring;
        this.method = method;
        this.marshallers = ClientMarshallerFactory.createMarshallers(declaring, method, providerFactory);
        this.providerFactory = providerFactory;
        this.executor = executor;
        this.accepts = MediaTypeHelper.getProduces(declaring, method);
        this.uri = new UriBuilderImpl();
        this.baseUri = baseUri;
        this.uri.uri(baseUri);
        if (declaring.isAnnotationPresent(Path.class)) {
            this.uri.path(declaring);
        }
        if (method.isAnnotationPresent(Path.class)) {
            this.uri.path(method);
        }
        this.extractorFactory = extractorFactory;
        this.extractor = extractorFactory.createExtractor(method);
    }

    public MediaType getAccepts() {
        return this.accepts;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class getDeclaring() {
        return this.declaring;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object[] args) {
        boolean isProvidersSet;
        boolean bl = isProvidersSet = ResteasyProviderFactory.getContextData(Providers.class) != null;
        if (!isProvidersSet) {
            ResteasyProviderFactory.pushContext(Providers.class, this.providerFactory);
        }
        try {
            if (this.uri == null) {
                throw new RuntimeException("You have not set a base URI for the client proxy");
            }
            ClientRequest request = this.createRequest(args);
            BaseClientResponse clientResponse = null;
            try {
                clientResponse = (BaseClientResponse)request.httpMethod(this.httpMethod);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ClientErrorHandler errorHandler = new ClientErrorHandler(this.providerFactory.getClientErrorInterceptors());
            clientResponse.setAttributeExceptionsTo(this.method.toString());
            clientResponse.setAnnotations(this.method.getAnnotations());
            ClientRequestContext clientRequestContext = new ClientRequestContext(request, clientResponse, errorHandler, this.extractorFactory, this.baseUri);
            Object t = this.extractor.extractEntity(clientRequestContext, new Object[0]);
            return t;
        }
        finally {
            if (!isProvidersSet) {
                ResteasyProviderFactory.popContextData(Providers.class);
            }
        }
    }

    protected ClientRequest createRequest(Object[] args) {
        ClientRequest request = new ClientRequest(this.uri, this.executor, this.providerFactory);
        if (this.accepts != null) {
            request.header("Accept", this.accepts.toString());
        }
        this.copyClientInterceptorsTo(request);
        boolean isClientResponseResult = ClientResponse.class.isAssignableFrom(this.method.getReturnType());
        request.followRedirects(!isClientResponseResult || this.followRedirects);
        for (int i = 0; i < this.marshallers.length; ++i) {
            this.marshallers[i].build(request, args[i]);
        }
        return request;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void followRedirects() {
        this.setFollowRedirects(true);
    }
}

