/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import java.io.IOException;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.util.automount.Automounter;
import org.jboss.vfs.util.automount.MountOption;

public abstract class AbstractVFSArchiveStructureDeployer
extends AbstractVFSStructureDeployer {
    public boolean determineStructure(StructureContext context) throws DeploymentException {
        VirtualFile root = context.getFile();
        boolean valid = false;
        try {
            if (!(!root.isFile() || this.shouldMount(root) && this.mountArchive(root))) {
                boolean bl = false;
                return bl;
            }
            valid = this.doDetermineStructure(context);
        }
        catch (DeploymentException e) {
            valid = false;
            throw e;
        }
        finally {
            if (!valid) {
                Automounter.cleanup((VirtualFile)root);
            }
        }
        return valid;
    }

    protected abstract boolean doDetermineStructure(StructureContext var1) throws DeploymentException;

    protected boolean hasValidName(VirtualFile root) {
        return this.hasValidSuffix(root.getName());
    }

    protected abstract boolean hasValidSuffix(String var1);

    protected boolean shouldMount(VirtualFile virtualFile) {
        return virtualFile.isFile() && this.hasValidName(virtualFile);
    }

    private boolean mountArchive(VirtualFile file) throws DeploymentException {
        try {
            this.performMount(file);
        }
        catch (IOException e) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Failed to mount archive: " + file), (Throwable)e);
        }
        return true;
    }

    protected void performMount(VirtualFile file) throws IOException {
        Automounter.mount((VirtualFile)file, (MountOption[])new MountOption[]{MountOption.COPY});
    }
}

