/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsf.deployer;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.resolver.MutableSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;
import org.jboss.xb.builder.JBossXBBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFImplMetaData {
    private static final VirtualFileFilter JAR_FILTER = new SuffixMatchFilter(".jar");
    private static final VirtualFileFilter TLD_FILTER = new SuffixMatchFilter(".tld", VisitorAttributes.DEFAULT);
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private String implName;
    private URL implURL;
    private Set<URL> jsfJars;
    private List<TldMetaData> sharedTldMetaData;
    private Web30MetaData sharedWebXml;

    public JSFImplMetaData(String implName, URL implURL) throws Exception {
        this.implName = implName;
        this.implURL = implURL;
        this.findJSFJars();
        this.parseJSFImplWebMetaData();
    }

    private void findJSFJars() throws Exception {
        VirtualFile vFile = VFS.getChild((URL)this.implURL);
        VirtualFile jsfLibsDir = vFile.getChild("jsf-libs");
        if (!jsfLibsDir.isDirectory()) {
            throw new Exception(this.implName + ": jsf-libs must be a directory");
        }
        HashSet<URL> jars = new HashSet<URL>();
        for (VirtualFile jarFile : jsfLibsDir.getChildren(JAR_FILTER)) {
            jars.add(jarFile.asFileURL());
        }
        this.jsfJars = Collections.unmodifiableSet(jars);
    }

    private void findTLDMetaData() throws URISyntaxException, IOException, JBossXBException {
        ArrayList<TldMetaData> sharedTlds = new ArrayList<TldMetaData>();
        if (this.jsfJars.isEmpty()) {
            return;
        }
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        MutableSchemaResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
        for (URL tldJar : this.jsfJars) {
            VirtualFile virtualFile = VFS.getChild((URL)tldJar);
            VirtualFile metaInf = virtualFile.getChild("META-INF");
            if (metaInf == null) continue;
            List tlds = metaInf.getChildren(TLD_FILTER);
            for (VirtualFile tld : tlds) {
                if (tld.getName().endsWith("mojarra_ext.tld")) continue;
                TldMetaData tldMetaData = (TldMetaData)unmarshaller.unmarshal(tld.toURL().toString(), (SchemaBindingResolver)resolver);
                sharedTlds.add(tldMetaData);
            }
        }
        this.sharedTldMetaData = Collections.unmodifiableList(sharedTlds);
    }

    protected void parseJSFImplWebMetaData() throws DeploymentException {
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        String webXml = this.implURL.toString() + "/META-INF/web.xml";
        SchemaBinding schema = JBossXBBuilder.build(Web30MetaData.class);
        try {
            this.sharedWebXml = (Web30MetaData)unmarshaller.unmarshal(webXml, schema);
        }
        catch (JBossXBException e) {
            throw new DeploymentException("Unable to parse web.xml at " + webXml, (Throwable)e);
        }
    }

    public String getImplName() {
        return this.implName;
    }

    public URL getImplURL() {
        return this.implURL;
    }

    public Web30MetaData getSharedWebXml() {
        return this.sharedWebXml;
    }

    public Set<URL> getJars() {
        return this.jsfJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TldMetaData> getTldMetaData() throws DeploymentException {
        try {
            JSFImplMetaData jSFImplMetaData = this;
            synchronized (jSFImplMetaData) {
                if (this.sharedTldMetaData == null) {
                    this.findTLDMetaData();
                }
            }
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException((String)("Unable to read TLD metadata for JSF implementation " + this.implName), (Throwable)e);
        }
        return this.sharedTldMetaData;
    }

    public String toString() {
        return "JSF Impl " + this.implName + ": " + this.implURL.toString();
    }
}

