/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;

public class TimedOutputStream
extends OutputStream {
    private static Timer timer = new Timer(true);
    private static Logger log = Logger.getLogger(TimedOutputStream.class);
    private OutputStream os;
    private int outputTimeout;
    private OutputTimerTask timerTask;
    private Object lock = new Object();

    public TimedOutputStream(OutputStream os, int outputTimeout) {
        this.os = os;
        this.outputTimeout = outputTimeout;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block16: {
                if (this.timerTask == null) {
                    try {
                        this.timerTask = new OutputTimerTask(this);
                        timer.schedule((TimerTask)this.timerTask, this.outputTimeout);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("scheduled OutputTimerTask: " + this.outputTimeout));
                        }
                    }
                    catch (IllegalStateException e) {
                        timer = new Timer(true);
                        timer.schedule((TimerTask)new OutputTimerTask(this), this.outputTimeout);
                        if (!log.isTraceEnabled()) break block16;
                        log.trace((Object)("scheduled OutputTimerTask: " + this.outputTimeout));
                    }
                }
            }
        }
        try {
            this.os.write(b);
        }
        finally {
            object = this.lock;
            synchronized (object) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block16: {
                if (this.timerTask == null) {
                    try {
                        this.timerTask = new OutputTimerTask(this);
                        timer.schedule((TimerTask)this.timerTask, this.outputTimeout);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)(this + " scheduled " + this.timerTask + ": " + this.outputTimeout));
                        }
                    }
                    catch (IllegalStateException e) {
                        timer = new Timer(true);
                        timer.schedule((TimerTask)new OutputTimerTask(this), this.outputTimeout);
                        if (!log.isTraceEnabled()) break block16;
                        log.trace((Object)(this + " scheduled " + this.timerTask + ": " + this.outputTimeout));
                    }
                }
            }
        }
        try {
            this.os.write(b, off, len);
        }
        finally {
            object = this.lock;
            synchronized (object) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
        }
    }

    static class OutputTimerTask
    extends TimerTask {
        private TimedOutputStream tos;

        public OutputTimerTask(TimedOutputStream tos) {
            this.tos = tos;
        }

        @Override
        public void run() {
            try {
                log.debug((Object)(this + " closing: " + this.tos));
                this.tos.close();
                this.tos = null;
            }
            catch (IOException e) {
                log.debug((Object)("unable to close " + this.tos));
            }
        }

        @Override
        public boolean cancel() {
            this.tos = null;
            return super.cancel();
        }
    }
}

