/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.network;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.remoting.detection.ServerInvokerMetadata;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkFilter;
import org.jboss.remoting.network.NetworkInstance;
import org.jboss.remoting.network.NetworkRegistryMBean;
import org.jboss.remoting.util.SecurityUtility;

public class NetworkRegistryWrapper
implements NetworkRegistryMBean {
    private NetworkRegistryMBean proxy;

    public NetworkRegistryWrapper(NetworkRegistryMBean proxy) {
        this.proxy = proxy;
    }

    @Override
    public void addServer(final Identity identity, final ServerInvokerMetadata[] invokers) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.addServer(identity, invokers);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NetworkRegistryWrapper.this.proxy.addServer(identity, invokers);
                return null;
            }
        });
    }

    @Override
    public void changeDomain(final String newDomain) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.changeDomain(newDomain);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NetworkRegistryWrapper.this.proxy.changeDomain(newDomain);
                return null;
            }
        });
    }

    @Override
    public NetworkInstance[] getServers() {
        if (SecurityUtility.skipAccessControl()) {
            return this.proxy.getServers();
        }
        return (NetworkInstance[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return NetworkRegistryWrapper.this.proxy.getServers();
            }
        });
    }

    @Override
    public boolean hasServer(final Identity identity) {
        if (SecurityUtility.skipAccessControl()) {
            return this.proxy.hasServer(identity);
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(NetworkRegistryWrapper.this.proxy.hasServer(identity));
            }
        });
    }

    @Override
    public NetworkInstance[] queryServers(final NetworkFilter filter) {
        if (SecurityUtility.skipAccessControl()) {
            return this.proxy.queryServers(filter);
        }
        return (NetworkInstance[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return NetworkRegistryWrapper.this.proxy.queryServers(filter);
            }
        });
    }

    @Override
    public void removeServer(final Identity identity) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.removeServer(identity);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NetworkRegistryWrapper.this.proxy.removeServer(identity);
                return null;
            }
        });
    }

    @Override
    public void updateServer(final Identity identity, final ServerInvokerMetadata[] invokers) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.updateServer(identity, invokers);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NetworkRegistryWrapper.this.proxy.updateServer(identity, invokers);
                return null;
            }
        });
    }

    @Override
    public void addNotificationListener(final NotificationListener listener, final NotificationFilter filter, final Object handback) throws IllegalArgumentException {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.addNotificationListener(listener, filter, handback);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalArgumentException {
                    NetworkRegistryWrapper.this.proxy.addNotificationListener(listener, filter, handback);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IllegalArgumentException)e.getCause();
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (SecurityUtility.skipAccessControl()) {
            return this.proxy.getNotificationInfo();
        }
        return (MBeanNotificationInfo[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return NetworkRegistryWrapper.this.proxy.getNotificationInfo();
            }
        });
    }

    @Override
    public void removeNotificationListener(final NotificationListener listener) throws ListenerNotFoundException {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.removeNotificationListener(listener);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ListenerNotFoundException {
                    NetworkRegistryWrapper.this.proxy.removeNotificationListener(listener);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (ListenerNotFoundException)e.getCause();
        }
    }

    @Override
    public void postDeregister() {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.postDeregister();
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NetworkRegistryWrapper.this.proxy.postDeregister();
                return null;
            }
        });
    }

    @Override
    public void postRegister(final Boolean registrationDone) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.postRegister(registrationDone);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NetworkRegistryWrapper.this.proxy.postRegister(registrationDone);
                return null;
            }
        });
    }

    @Override
    public void preDeregister() throws Exception {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.preDeregister();
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    NetworkRegistryWrapper.this.proxy.preDeregister();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }

    @Override
    public ObjectName preRegister(final MBeanServer server, final ObjectName name) throws Exception {
        if (SecurityUtility.skipAccessControl()) {
            return this.proxy.preRegister(server, name);
        }
        try {
            return (ObjectName)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return NetworkRegistryWrapper.this.proxy.preRegister(server, name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }
}

