/*
 * Decompiled with CFR 0.152.
 */
package org.apache.neethi;

import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.neethi.All;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyOperator;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.builders.AssertionBuilder;

public class PolicyEngine {
    public static final String POLICY_NAMESPACE = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    public static final String POLICY = "Policy";
    public static final String EXACTLY_ONE = "ExactlyOne";
    public static final String ALL = "All";
    public static final String POLICY_REF = "PolicyReference";
    private static AssertionBuilderFactory factory = new AssertionBuilderFactory();

    public static void registerBuilder(QName qname, AssertionBuilder builder) {
        AssertionBuilderFactory.registerBuilder(qname, builder);
    }

    public static Policy getPolicy(InputStream inputStream) {
        try {
            OMElement element = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)XMLInputFactory.newInstance().createXMLStreamReader(inputStream)).getDocumentElement();
            return PolicyEngine.getPolicy(element);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static PolicyReference getPolicyReferene(InputStream inputStream) {
        try {
            OMElement element = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)XMLInputFactory.newInstance().createXMLStreamReader(inputStream)).getDocumentElement();
            return PolicyEngine.getPolicyReference(element);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Policy getPolicy(OMElement element) {
        return PolicyEngine.getPolicyOperator(element);
    }

    public static PolicyReference getPolicyReference(OMElement element) {
        if (!POLICY_NAMESPACE.equals(element.getNamespace().getNamespaceURI()) || !POLICY_REF.equals(element.getLocalName())) {
            throw new RuntimeException("Specified element is not a <wsp:PolicyReference .. />  element");
        }
        PolicyReference reference = new PolicyReference();
        reference.setURI(element.getAttributeValue(new QName("URI")));
        return reference;
    }

    private static Policy getPolicyOperator(OMElement element) {
        return (Policy)PolicyEngine.processOperationElement(element, new Policy());
    }

    private static ExactlyOne getExactlyOneOperator(OMElement element) {
        return (ExactlyOne)PolicyEngine.processOperationElement(element, new ExactlyOne());
    }

    private static All getAllOperator(OMElement element) {
        return (All)PolicyEngine.processOperationElement(element, new All());
    }

    private static PolicyOperator processOperationElement(OMElement operationElement, PolicyOperator operator) {
        if (1 == operator.getType()) {
            Policy policyOperator = (Policy)operator;
            Iterator iterator = operationElement.getAllAttributes();
            while (iterator.hasNext()) {
                OMAttribute attribute = (OMAttribute)iterator.next();
                OMNamespace namespace = attribute.getNamespace();
                QName key = namespace == null ? new QName(attribute.getLocalName()) : (namespace.getPrefix() == null ? new QName(namespace.getNamespaceURI(), attribute.getLocalName()) : new QName(namespace.getNamespaceURI(), attribute.getLocalName(), namespace.getPrefix()));
                policyOperator.addAttribute(key, attribute.getAttributeValue());
            }
        }
        Iterator iterator = operationElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement childElement = (OMElement)iterator.next();
            if (POLICY_NAMESPACE.equals(childElement.getNamespace().getNamespaceURI())) {
                if (POLICY.equals(childElement.getLocalName())) {
                    operator.addPolicyComponent(PolicyEngine.getPolicyOperator(childElement));
                    continue;
                }
                if (EXACTLY_ONE.equals(childElement.getLocalName())) {
                    operator.addPolicyComponent(PolicyEngine.getExactlyOneOperator(childElement));
                    continue;
                }
                if (ALL.equals(childElement.getLocalName())) {
                    operator.addPolicyComponent(PolicyEngine.getAllOperator(childElement));
                    continue;
                }
                if (!POLICY_REF.equals(childElement.getLocalName())) continue;
                operator.addPolicyComponent(PolicyEngine.getPolicyReference(childElement));
                continue;
            }
            operator.addPolicyComponent(factory.build(childElement));
        }
        return operator;
    }
}

