/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.mc.deployer;

import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.ManagedBean;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.bean.metadata.ManagedBeanDeploymentMetaData;
import org.jboss.managed.bean.metadata.jbmeta.annotation.processor.ManagedBeanMetaDataCreator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.scanning.annotations.spi.AnnotationIndex;
import org.jboss.scanning.annotations.spi.Element;

public class ManagedBeanAnnotationMetaDataDeployer
extends AbstractDeployer {
    private static Logger logger = Logger.getLogger(ManagedBeanAnnotationMetaDataDeployer.class);
    public static String MANAGED_BEAN_DEPLOYMENT_METADATA_ATTACHMENT_KEY = ManagedBeanDeploymentMetaData.class.getName();

    public ManagedBeanAnnotationMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.setInput(AnnotationIndex.class);
        this.setOutput(ManagedBeanDeploymentMetaData.class);
        this.addOutput(MANAGED_BEAN_DEPLOYMENT_METADATA_ATTACHMENT_KEY);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        List classpath = vfsDeploymentUnit.getClassPath();
        if (classpath == null || classpath.isEmpty()) {
            logger.tracef("Skipping unit %s because classpath is empty", new Object[]{unit.getName()});
            return;
        }
        AnnotationIndex annotationIndex = (AnnotationIndex)unit.getAttachment(AnnotationIndex.class);
        if (annotationIndex == null) {
            logger.tracef("Skipping unit %s because AnnotationIndex is absent", new Object[]{unit.getName()});
            return;
        }
        Set annotatedElements = annotationIndex.classIsAnnotatedWith(ManagedBean.class);
        if (annotatedElements == null || annotatedElements.isEmpty()) {
            logger.tracef("Skipping unit %s because no @ManagedBean annotated classes found", new Object[]{unit.getName()});
            return;
        }
        HashSet<AnnotatedElement> annotatedClasses = new HashSet<AnnotatedElement>(annotatedElements.size());
        for (Element element : annotatedElements) {
            annotatedClasses.add(element.getAnnotatedElement());
        }
        ManagedBeanMetaDataCreator managedBeanMetaDataCreator = new ManagedBeanMetaDataCreator((AnnotationFinder)new DefaultAnnotationFinder());
        logger.debugf("Creating metadata for @ManagedBean annotated classes for unit %s", new Object[]{unit.getName()});
        ManagedBeanDeploymentMetaData managedBeanDeploymentMetaData = managedBeanMetaDataCreator.create(annotatedClasses);
        int numManagedBeans = managedBeanDeploymentMetaData.getManagedBeans() == null ? 0 : managedBeanDeploymentMetaData.getManagedBeans().size();
        logger.debugf("%d managed beans found in unit %s", new Object[]{numManagedBeans, unit.getName()});
        unit.addAttachment(MANAGED_BEAN_DEPLOYMENT_METADATA_ATTACHMENT_KEY, (Object)managedBeanDeploymentMetaData, ManagedBeanDeploymentMetaData.class);
    }
}

