/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.java.JavaSystem;

public class HsqlProperties {
    public static final int NO_VALUE_FOR_KEY = 1;
    protected String fileName;
    protected Properties stringProps;
    protected int[] errorCodes = new int[0];
    protected String[] errorKeys = new String[0];
    protected boolean resource = false;
    protected FileAccess fa;

    public HsqlProperties() {
        this.stringProps = new Properties();
        this.fileName = null;
    }

    public HsqlProperties(String string) {
        this.stringProps = new Properties();
        this.fileName = string;
        this.fa = FileUtil.getDefaultInstance();
    }

    public HsqlProperties(String string, FileAccess fileAccess, boolean bl) {
        this.stringProps = new Properties();
        this.fileName = string;
        this.resource = bl;
        this.fa = fileAccess;
    }

    public HsqlProperties(Properties properties) {
        this.stringProps = properties;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String setProperty(String string, int n) {
        return this.setProperty(string, Integer.toString(n));
    }

    public String setProperty(String string, boolean bl) {
        return this.setProperty(string, String.valueOf(bl));
    }

    public String setProperty(String string, String string2) {
        return (String)this.stringProps.put(string, string2);
    }

    public String setPropertyIfNotExists(String string, String string2) {
        string2 = this.getProperty(string, string2);
        return this.setProperty(string, string2);
    }

    public Properties getProperties() {
        return this.stringProps;
    }

    public String getProperty(String string) {
        return this.stringProps.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.stringProps.getProperty(string, string2);
    }

    public int getIntegerProperty(String string, int n) {
        String string2 = this.getProperty(string);
        try {
            if (string2 != null) {
                n = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public int getIntegerProperty(String string, int n, int n2, int n3) {
        String string2 = this.getProperty(string);
        boolean bl = false;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < n2) {
            n = n2;
            bl = true;
        } else if (n > n3) {
            n = n3;
            bl = true;
        }
        return n;
    }

    public int getIntegerProperty(String string, int n, int[] nArray) {
        String string2 = this.getProperty(string);
        int n2 = n;
        try {
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (ArrayUtil.find(nArray, n2) == -1) {
            return n;
        }
        return n2;
    }

    public boolean isPropertyTrue(String string) {
        return this.isPropertyTrue(string, false);
    }

    public boolean isPropertyTrue(String string, boolean bl) {
        String string2 = this.stringProps.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.toLowerCase().equals("true");
    }

    public void removeProperty(String string) {
        this.stringProps.remove(string);
    }

    public void addProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            this.stringProps.put(object, properties.get(object));
        }
    }

    public void addProperties(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        this.addProperties(hsqlProperties.stringProps);
    }

    public boolean checkFileExists() throws IOException {
        String string = this.fileName + ".properties";
        return this.fa.isStreamElement(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() throws Exception {
        if (!this.checkFileExists()) {
            return false;
        }
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException(Trace.getMessage(135));
        }
        InputStream inputStream = null;
        String string = this.fileName + ".properties";
        try {
            inputStream = this.resource ? this.getClass().getResourceAsStream(string) : this.fa.openInputStreamElement(string);
            this.stringProps.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return true;
    }

    public void save() throws Exception {
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException(Trace.getMessage(135));
        }
        String string = this.fileName + ".properties";
        this.save(string);
    }

    public void save(String string) throws Exception {
        this.fa.createParentDirs(string);
        OutputStream outputStream = this.fa.openOutputStreamElement(string);
        JavaSystem.saveProperties(this.stringProps, "HSQL Database Engine 1.8.0.8", outputStream);
        outputStream.close();
    }

    private void addError(int n, String string) {
        this.errorCodes = (int[])ArrayUtil.resizeArray(this.errorCodes, this.errorCodes.length + 1);
        this.errorKeys = (String[])ArrayUtil.resizeArray(this.errorKeys, this.errorKeys.length + 1);
        this.errorCodes[this.errorCodes.length - 1] = n;
        this.errorKeys[this.errorKeys.length - 1] = string;
    }

    public static HsqlProperties argArrayToProps(String[] stringArray, String string) {
        HsqlProperties hsqlProperties = new HsqlProperties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.startsWith("-?")) {
                hsqlProperties.addError(1, string2.substring(1));
                continue;
            }
            if (string2.charAt(0) != '-') continue;
            hsqlProperties.setProperty(string + "." + string2.substring(1), stringArray[i + 1]);
            ++i;
        }
        return hsqlProperties;
    }

    public static HsqlProperties delimitedArgPairsToProps(String string, String string2, String string3, String string4) {
        HsqlProperties hsqlProperties = new HsqlProperties();
        int n = 0;
        while (true) {
            int n2;
            int n3;
            if ((n3 = string.indexOf(string3, n)) == -1) {
                n3 = string.length();
            }
            if ((n2 = string.substring(0, n3).indexOf(string2, n)) == -1) {
                hsqlProperties.addError(1, string.substring(n, n3).trim());
            } else {
                String string5 = string.substring(n, n2).trim();
                String string6 = string.substring(n2 + string2.length(), n3).trim();
                if (string4 != null) {
                    string5 = string4 + "." + string5;
                }
                hsqlProperties.setProperty(string5, string6);
            }
            if (n3 == string.length()) break;
            n = n3 + string3.length();
        }
        return hsqlProperties;
    }

    public Enumeration propertyNames() {
        return this.stringProps.propertyNames();
    }

    public boolean isEmpty() {
        return this.stringProps.isEmpty();
    }

    public String[] getErrorKeys() {
        return this.errorKeys;
    }
}

