/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.deployers;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitFilter;
import org.jboss.scanning.deployers.DefaultDeploymentUnitScannerFactory;
import org.jboss.scanning.deployers.DeploymentUnitScannerFactory;
import org.jboss.scanning.plugins.DeploymentScanningPluginFactory;
import org.jboss.scanning.plugins.DeploymentUnitScanner;
import org.jboss.scanning.spi.ScanningPlugin;
import org.jboss.scanning.spi.metadata.ScanningMetaData;

public class ScanningDeployer
extends AbstractDeployer {
    public static String PLUGINS_KEY = "SCANNING_PLUGINS_KEY";
    private DeploymentUnitFilter filter;
    private Set<DeploymentScanningPluginFactory> factories = new CopyOnWriteArraySet<DeploymentScanningPluginFactory>();
    private DeploymentUnitScannerFactory factory = new DefaultDeploymentUnitScannerFactory();

    public ScanningDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(ScanningMetaData.class);
    }

    public void create() {
        if (this.factory == null) {
            throw new IllegalArgumentException("Null DU scanner factory");
        }
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (this.filter != null && !this.filter.accepts(unit)) {
            return;
        }
        HashSet<ScanningPlugin> plugins = new HashSet<ScanningPlugin>();
        for (DeploymentScanningPluginFactory factory : this.factories) {
            if (!factory.isRelevant(unit)) continue;
            plugins.add(factory.create(unit));
        }
        if (!plugins.isEmpty()) {
            try {
                DeploymentUnitScanner scanner = this.factory.create(unit);
                if (scanner.doScan()) {
                    scanner.setPlugins(plugins);
                    scanner.setIgnoreIndexedHandles(unit.isAttachmentPresent("jboss.scanning.ignoreIndexedHandles"));
                    scanner.setIgnoreRuntimeScanning(unit.isAttachmentPresent("jboss.scanning.ignoreRuntimeScanning"));
                    scanner.scan();
                    unit.addAttachment(PLUGINS_KEY, plugins);
                }
            }
            catch (Exception e) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Error scanning deployment: " + unit), (Throwable)e);
            }
        }
    }

    public void addFactory(DeploymentScanningPluginFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        this.factories.add(factory);
        String output = factory.getPluginOutput();
        if (output != null) {
            this.addOutput(output);
        }
    }

    public void removeFactory(DeploymentScanningPluginFactory factory) {
        if (factory == null) {
            return;
        }
        this.factories.remove(factory);
    }

    public void setFilter(DeploymentUnitFilter filter) {
        this.filter = filter;
    }

    public void setFactory(DeploymentUnitScannerFactory factory) {
        this.factory = factory;
    }
}

