/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.deployers.ScanningDeployer;
import org.jboss.scanning.spi.ScanningPlugin;

public class HandleCleanupDeployer
extends AbstractDeployer {
    public static DeploymentStage CLEANUP = new DeploymentStage("Cleanup", DeploymentStages.REAL, DeploymentStages.INSTALLED);

    public HandleCleanupDeployer() {
        this.setStage(CLEANUP);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        Iterable plugins = (Iterable)unit.getAttachment(ScanningDeployer.PLUGINS_KEY, Iterable.class);
        if (plugins != null) {
            for (ScanningPlugin plugin : plugins) {
                Object handle = unit.removeAttachment(plugin.getAttachmentKey());
                if (handle == null) continue;
                plugin.cleanupHandle(handle);
            }
        }
    }
}

