/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.stdio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.Permission;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.stdio.NullOutputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContextSelector;

public final class StdioContext {
    private static final StdioContext SYSTEM_STDIO_CONTEXT = new StdioContext(System.in, System.out, System.err);
    private static final Permission CREATE_CONTEXT_PERMISSION = new RuntimePermission("createStdioContext", null);
    private static final Permission SET_CONTEXT_SELECTOR_PERMISSION = new RuntimePermission("setStdioContextSelector", null);
    private static final Permission INSTALL_PERMISSION = new RuntimePermission("installStdioContextSelector", null);
    private static final AtomicReference<State> state = new AtomicReference<State>(State.UNINSTALLED);
    private final InputStream in;
    private final PrintStream out;
    private final PrintStream err;
    private static volatile StdioContextSelector stdioContextSelector = new SimpleStdioContextSelector(SYSTEM_STDIO_CONTEXT);

    StdioContext(InputStream in, PrintStream out, PrintStream err) {
        this.in = in;
        this.out = out;
        this.err = err;
    }

    public static StdioContext create(InputStream in, PrintStream out, PrintStream err) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_CONTEXT_PERMISSION);
        }
        return new StdioContext(in, out, err);
    }

    public static StdioContext create(InputStream in, OutputStream out, OutputStream err) throws SecurityException {
        return StdioContext.create(in, new PrintStream(out, true), new PrintStream(err, true));
    }

    public static StdioContext getStdioContext() {
        return stdioContextSelector.getStdioContext();
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public static void install() throws SecurityException, IllegalStateException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(INSTALL_PERMISSION);
        }
        if (!state.compareAndSet(State.UNINSTALLED, State.INSTALLING)) {
            throw new IllegalStateException("Already installed");
        }
        System.setOut(new DelegatingPrintStream(){

            PrintStream getDelegate() {
                return stdioContextSelector.getStdioContext().out;
            }
        });
        System.setErr(new DelegatingPrintStream(){

            PrintStream getDelegate() {
                return stdioContextSelector.getStdioContext().err;
            }
        });
        System.setIn(new DelegatingInputStream(){

            InputStream getDelegate() {
                return stdioContextSelector.getStdioContext().in;
            }
        });
        state.set(State.INSTALLED);
    }

    public static void uninstall() throws SecurityException, IllegalStateException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(INSTALL_PERMISSION);
        }
        if (!state.compareAndSet(State.INSTALLED, State.UNINSTALLING)) {
            throw new IllegalStateException("Already uninstalled");
        }
        System.setOut(StdioContext.SYSTEM_STDIO_CONTEXT.out);
        System.setErr(StdioContext.SYSTEM_STDIO_CONTEXT.err);
        System.setIn(StdioContext.SYSTEM_STDIO_CONTEXT.in);
        state.set(State.UNINSTALLED);
    }

    public static void setStdioContextSelector(StdioContextSelector stdioContextSelector) throws SecurityException {
        if (stdioContextSelector == null) {
            throw new NullPointerException("stdioContextSelector is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT_SELECTOR_PERMISSION);
        }
        StdioContext.stdioContextSelector = stdioContextSelector;
    }

    private static abstract class DelegatingInputStream
    extends InputStream {
        private DelegatingInputStream() {
        }

        abstract InputStream getDelegate();

        public int read() throws IOException {
            return this.getDelegate().read();
        }

        public int read(byte[] b) throws IOException {
            return this.getDelegate().read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.getDelegate().read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.getDelegate().skip(n);
        }

        public int available() throws IOException {
            return this.getDelegate().available();
        }

        public void close() throws IOException {
            this.getDelegate().close();
        }

        public void mark(int readLimit) {
            this.getDelegate().mark(readLimit);
        }

        public void reset() throws IOException {
            this.getDelegate().reset();
        }

        public boolean markSupported() {
            return this.getDelegate().markSupported();
        }
    }

    private static abstract class DelegatingPrintStream
    extends PrintStream {
        protected DelegatingPrintStream() {
            super(NullOutputStream.getInstance());
        }

        abstract PrintStream getDelegate();

        public void flush() {
            this.getDelegate().flush();
        }

        public void close() {
            this.getDelegate().close();
        }

        public boolean checkError() {
            return this.getDelegate().checkError();
        }

        public void write(int b) {
            this.getDelegate().write(b);
        }

        public void write(byte[] buf, int off, int len) {
            this.getDelegate().write(buf, off, len);
        }

        public void print(boolean b) {
            this.getDelegate().print(b);
        }

        public void print(char c) {
            this.getDelegate().print(c);
        }

        public void print(int i) {
            this.getDelegate().print(i);
        }

        public void print(long l) {
            this.getDelegate().print(l);
        }

        public void print(float f) {
            this.getDelegate().print(f);
        }

        public void print(double d) {
            this.getDelegate().print(d);
        }

        public void print(char[] s) {
            this.getDelegate().print(s);
        }

        public void print(String s) {
            this.getDelegate().print(s);
        }

        public void print(Object obj) {
            this.getDelegate().print(obj);
        }

        public void println() {
            this.getDelegate().println();
        }

        public void println(boolean x) {
            this.getDelegate().println(x);
        }

        public void println(char x) {
            this.getDelegate().println(x);
        }

        public void println(int x) {
            this.getDelegate().println(x);
        }

        public void println(long x) {
            this.getDelegate().println(x);
        }

        public void println(float x) {
            this.getDelegate().println(x);
        }

        public void println(double x) {
            this.getDelegate().println(x);
        }

        public void println(char[] x) {
            this.getDelegate().println(x);
        }

        public void println(String x) {
            this.getDelegate().println(x);
        }

        public void println(Object x) {
            this.getDelegate().println(x);
        }

        public PrintStream printf(String format, Object ... args) {
            return this.getDelegate().printf(format, args);
        }

        public PrintStream printf(Locale l, String format, Object ... args) {
            return this.getDelegate().printf(l, format, args);
        }

        public PrintStream format(String format, Object ... args) {
            return this.getDelegate().format(format, args);
        }

        public PrintStream format(Locale l, String format, Object ... args) {
            return this.getDelegate().format(l, format, args);
        }

        public PrintStream append(CharSequence csq) {
            return this.getDelegate().append(csq);
        }

        public PrintStream append(CharSequence csq, int start, int end) {
            return this.getDelegate().append(csq, start, end);
        }

        public PrintStream append(char c) {
            return this.getDelegate().append(c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNINSTALLED,
        INSTALLING,
        INSTALLED,
        UNINSTALLING;

    }
}

