/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.contact;

import com.arjuna.ArjunaOTS.ArjunaFactory;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem;
import com.arjuna.ats.jts.OTSManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import com.arjuna.orbportability.ORBInfo;
import java.util.Hashtable;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.otid_t;

public class StatusChecker {
    private Hashtable _itemFromUid = new Hashtable();
    private static StatusChecker _checker = new StatusChecker();

    public static Status get_status(Uid transactionUid, Uid itemUid) throws Inactive {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("StatusChecker.get_status(" + transactionUid + ", " + itemUid + ")"));
        }
        return _checker.checkOriginalStatus(transactionUid, itemUid, true);
    }

    public static Status get_current_status(Uid transactionUid, Uid itemUid) throws Inactive {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("StatusChecker.get_current_status(" + transactionUid + ", " + itemUid + ")"));
        }
        return _checker.checkOriginalStatus(transactionUid, itemUid, false);
    }

    public Status checkOriginalStatus(Uid transactionUid, Uid itemUid, boolean checkTheObjectStore) throws Inactive {
        FactoryContactItem item;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("StatusChecker.checkOriginalStatus(" + transactionUid + ", " + itemUid + ", " + checkTheObjectStore + ")"));
        }
        if ((item = this.getItem(itemUid)) != null) {
            return this.getStatus(transactionUid, item, checkTheObjectStore);
        }
        throw new Inactive();
    }

    private Status getStatus(Uid transactionUid, FactoryContactItem item, boolean checkTheObjectStore) throws Inactive {
        ArjunaFactory factory;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("StatusChecker.getStatus(" + transactionUid + ", " + item + ", " + checkTheObjectStore + ")"));
        }
        if ((factory = item.getFactory()) != null) {
            Status otsStatus = Status.StatusUnknown;
            boolean originalDead = false;
            try {
                otid_t otid = Utility.uidToOtid(transactionUid);
                otsStatus = factory.getCurrentStatus(otid);
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug((Object)("StatusChecker.getStatus(" + transactionUid + ") - current status = " + Utility.stringStatus(otsStatus)));
                }
                if (otsStatus == Status.StatusNoTransaction) {
                    otsStatus = factory.getStatus(otid);
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug((Object)("StatusChecker.getStatus(" + transactionUid + ") - stored status = " + Utility.stringStatus(otsStatus)));
                    }
                    switch (otsStatus.value()) {
                        case 9: {
                            return otsStatus;
                        }
                        case 5: {
                            return otsStatus;
                        }
                    }
                    jtsLogger.i18NLogger.warn_recovery_contact_StatusChecker_3(transactionUid);
                    otsStatus = Status.StatusUnknown;
                }
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug((Object)("StatusChecker.getStatus(" + transactionUid + ") - Status = " + Utility.stringStatus(otsStatus)));
                }
                item.markAsAlive();
            }
            catch (NO_IMPLEMENT ex_noimp) {
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug((Object)("StatusChecker.getStatus(" + transactionUid + ") - NO_IMPLEMENT = dead"));
                }
                originalDead = true;
            }
            catch (TRANSIENT ex_trans) {
                if (ORBInfo.getOrbEnumValue() == 4) {
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug((Object)("StatusChecker.getStatus(" + transactionUid + ") - TRANSIENT = dead"));
                    }
                    originalDead = true;
                }
            }
            catch (COMM_FAILURE ex_comm) {
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug((Object)("StatusChecker.getStatus(" + transactionUid + ") - COMM_FAILURE = live"));
                }
            }
            catch (OBJECT_NOT_EXIST ex_noobj) {
                originalDead = true;
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug((Object)("StatusChecker.getStatus(" + transactionUid + ") - OBJECT_NOT_EXIST = dead"));
                }
            }
            catch (BAD_PARAM ex_badparam) {
                jtsLogger.i18NLogger.warn_recovery_contact_StatusChecker_9();
            }
            catch (NoTransaction ex_notran) {
                jtsLogger.i18NLogger.warn_recovery_contact_StatusChecker_10();
            }
            catch (SystemException ex_corba) {
                jtsLogger.i18NLogger.warn_recovery_contact_StatusChecker_11(ex_corba);
            }
            catch (Exception ex_other) {
                jtsLogger.i18NLogger.warn_recovery_contact_StatusChecker_12(ex_other);
            }
            if (originalDead) {
                item.markAsDead();
                throw new Inactive();
            }
            return otsStatus;
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("StatusChecker.getStatus(" + transactionUid + ") -  no factory, process previously dead"));
        }
        if (checkTheObjectStore) {
            try {
                Status s = OTSManager.factory().getStatus(transactionUid);
                if (s == Status.StatusCommitting) {
                    return Status.StatusCommitted;
                }
                if (s == Status.StatusRollingBack) {
                    return Status.StatusRolledBack;
                }
                return s;
            }
            catch (NoTransaction e1) {
                return Status.StatusNoTransaction;
            }
            catch (SystemException e2) {
                return Status.StatusUnknown;
            }
        }
        throw new Inactive();
    }

    private FactoryContactItem getItem(Uid uid) {
        FactoryContactItem theItem = null;
        theItem = this.getKnownItem(uid);
        if (theItem == null && (theItem = this.getNewItem(uid)) == null) {
            jtsLogger.i18NLogger.warn_recovery_contact_StatusChecker_14(uid);
        }
        return theItem;
    }

    private FactoryContactItem getKnownItem(Uid uid) {
        FactoryContactItem theItem = null;
        try {
            theItem = (FactoryContactItem)this._itemFromUid.get(uid);
            return theItem;
        }
        catch (ClassCastException ex) {
            jtsLogger.i18NLogger.warn_recovery_contact_StatusChecker_15(uid, ex);
            return null;
        }
    }

    private FactoryContactItem getNewItem(Uid uid) {
        FactoryContactItem item = FactoryContactItem.recreate(uid);
        if (item != null) {
            this._itemFromUid.put(uid, item);
        }
        return item;
    }
}

