/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.io.Serializable;
import org.jboss.remoting3.Client;
import org.jboss.remoting3.ClientConnector;
import org.jboss.remoting3.ClientContext;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.spi.RemoteRequestHandler;
import org.jboss.remoting3.spi.RequestHandlerConnector;
import org.jboss.xnio.FutureResult;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.Result;
import org.jboss.xnio.TranslatingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClientConnectorImpl<I, O>
implements ClientConnector<I, O>,
Serializable {
    private static final long serialVersionUID = -263585821458635701L;
    private final transient ClientContext clientContext;
    private final RequestHandlerConnector requestHandlerConnector;
    private final EndpointImpl endpoint;
    private final Class<I> requestClass;
    private final Class<O> replyClass;

    ClientConnectorImpl(RequestHandlerConnector requestHandlerConnector, EndpointImpl endpoint, Class<I> requestClass, Class<O> replyClass, ClientContext clientContext) {
        this.requestHandlerConnector = requestHandlerConnector;
        this.endpoint = endpoint;
        this.requestClass = requestClass;
        this.replyClass = replyClass;
        this.clientContext = clientContext;
    }

    @Override
    public IoFuture<? extends Client<I, O>> getFutureClient() throws SecurityException {
        return this.getFutureClient(Thread.currentThread().getContextClassLoader());
    }

    @Override
    public IoFuture<? extends Client<I, O>> getFutureClient(final ClassLoader classloader) throws SecurityException {
        FutureResult futureResult = new FutureResult();
        this.requestHandlerConnector.createRequestHandler((Result<RemoteRequestHandler>)new TranslatingResult<RemoteRequestHandler, Client<I, O>>((Result)futureResult){

            protected Client<I, O> translate(RemoteRequestHandler input) throws IOException {
                return ClientConnectorImpl.this.endpoint.createClient(input, ClientConnectorImpl.this.requestClass, ClientConnectorImpl.this.replyClass, classloader);
            }
        });
        return futureResult.getIoFuture();
    }

    @Override
    public ClientContext getClientContext() {
        if (this.clientContext == null) {
            throw new SecurityException("Connector has already been sent");
        }
        return this.clientContext;
    }
}

