/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.log;

import org.jboss.xnio.log.XnioLogRecord;

public final class Logger {
    public static final java.util.logging.Level TRACE = new Level("TRACE", 400);
    public static final java.util.logging.Level DEBUG = new Level("DEBUG", 500);
    public static final java.util.logging.Level INFO = new Level("INFO", 800);
    public static final java.util.logging.Level WARN = new Level("WARN", 900);
    public static final java.util.logging.Level ERROR = new Level("ERROR", 1000);
    private final java.util.logging.Logger logger;
    private final String name;

    private Logger(String name) {
        this.name = name;
        this.logger = java.util.logging.Logger.getLogger(name);
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    public static Logger getLogger(Class<?> claxx) {
        return Logger.getLogger(claxx.getName());
    }

    public boolean isTrace() {
        return this.logger.isLoggable(TRACE);
    }

    private void doLog(java.util.logging.Level level, String msg, Throwable ex, Object ... params) {
        try {
            String fmtMsg = params != null && params.length > 0 ? String.format(msg, params) : msg;
            XnioLogRecord record = new XnioLogRecord(level, fmtMsg);
            record.setLoggerName(this.name);
            if (ex != null) {
                record.setThrown(ex);
            }
            this.logger.log(record);
        }
        catch (Throwable throwable) {}
    }

    public void error(String msg) {
        if (this.logger.isLoggable(ERROR)) {
            this.doLog(ERROR, msg, null, null);
        }
    }

    public void error(Throwable ex, String msg, Object ... params) {
        if (this.logger.isLoggable(ERROR)) {
            this.doLog(ERROR, msg, ex, params);
        }
    }

    public void error(Throwable ex, String msg, Object param1) {
        if (this.logger.isLoggable(ERROR)) {
            this.doLog(ERROR, msg, ex, param1);
        }
    }

    public void error(Throwable ex, String msg, Object param1, Object param2) {
        if (this.logger.isLoggable(ERROR)) {
            this.doLog(ERROR, msg, ex, param1, param2);
        }
    }

    public void error(Throwable ex, String msg, Object param1, Object param2, Object param3) {
        if (this.logger.isLoggable(ERROR)) {
            this.doLog(ERROR, msg, ex, param1, param2, param3);
        }
    }

    public void error(String msg, Object ... params) {
        if (this.logger.isLoggable(ERROR)) {
            this.doLog(ERROR, msg, null, params);
        }
    }

    public void error(String msg, Object param1) {
        if (this.logger.isLoggable(ERROR)) {
            this.doLog(ERROR, msg, null, param1);
        }
    }

    public void error(String msg, Object param1, Object param2) {
        if (this.logger.isLoggable(ERROR)) {
            this.doLog(ERROR, msg, null, param1, param2);
        }
    }

    public void error(String msg, Object param1, Object param2, Object param3) {
        if (this.logger.isLoggable(ERROR)) {
            this.doLog(ERROR, msg, null, param1, param2, param3);
        }
    }

    public void warn(String msg) {
        if (this.logger.isLoggable(WARN)) {
            this.doLog(WARN, msg, null, null);
        }
    }

    public void warn(Throwable ex, String msg, Object ... params) {
        if (this.logger.isLoggable(WARN)) {
            this.doLog(WARN, msg, ex, params);
        }
    }

    public void warn(Throwable ex, String msg, Object param1) {
        if (this.logger.isLoggable(WARN)) {
            this.doLog(WARN, msg, ex, param1);
        }
    }

    public void warn(Throwable ex, String msg, Object param1, Object param2) {
        if (this.logger.isLoggable(WARN)) {
            this.doLog(WARN, msg, ex, param1, param2);
        }
    }

    public void warn(Throwable ex, String msg, Object param1, Object param2, Object param3) {
        if (this.logger.isLoggable(WARN)) {
            this.doLog(WARN, msg, ex, param1, param2, param3);
        }
    }

    public void warn(String msg, Object ... params) {
        if (this.logger.isLoggable(WARN)) {
            this.doLog(WARN, msg, null, params);
        }
    }

    public void warn(String msg, Object param1) {
        if (this.logger.isLoggable(WARN)) {
            this.doLog(WARN, msg, null, param1);
        }
    }

    public void warn(String msg, Object param1, Object param2) {
        if (this.logger.isLoggable(WARN)) {
            this.doLog(WARN, msg, null, param1, param2);
        }
    }

    public void warn(String msg, Object param1, Object param2, Object param3) {
        if (this.logger.isLoggable(WARN)) {
            this.doLog(WARN, msg, null, param1, param2, param3);
        }
    }

    public void info(String msg) {
        if (this.logger.isLoggable(INFO)) {
            this.doLog(INFO, msg, null, null);
        }
    }

    public void info(Throwable ex, String msg, Object ... params) {
        if (this.logger.isLoggable(INFO)) {
            this.doLog(INFO, msg, ex, params);
        }
    }

    public void info(Throwable ex, String msg, Object param1) {
        if (this.logger.isLoggable(INFO)) {
            this.doLog(INFO, msg, ex, param1);
        }
    }

    public void info(Throwable ex, String msg, Object param1, Object param2) {
        if (this.logger.isLoggable(INFO)) {
            this.doLog(INFO, msg, ex, param1, param2);
        }
    }

    public void info(Throwable ex, String msg, Object param1, Object param2, Object param3) {
        if (this.logger.isLoggable(INFO)) {
            this.doLog(INFO, msg, ex, param1, param2, param3);
        }
    }

    public void info(String msg, Object ... params) {
        if (this.logger.isLoggable(INFO)) {
            this.doLog(INFO, msg, null, params);
        }
    }

    public void info(String msg, Object param1) {
        if (this.logger.isLoggable(INFO)) {
            this.doLog(INFO, msg, null, param1);
        }
    }

    public void info(String msg, Object param1, Object param2) {
        if (this.logger.isLoggable(INFO)) {
            this.doLog(INFO, msg, null, param1, param2);
        }
    }

    public void info(String msg, Object param1, Object param2, Object param3) {
        if (this.logger.isLoggable(INFO)) {
            this.doLog(INFO, msg, null, param1, param2, param3);
        }
    }

    public void debug(String msg) {
        if (this.logger.isLoggable(DEBUG)) {
            this.doLog(DEBUG, msg, null, null);
        }
    }

    public void debug(Throwable ex, String msg, Object ... params) {
        if (this.logger.isLoggable(DEBUG)) {
            this.doLog(DEBUG, msg, ex, params);
        }
    }

    public void debug(Throwable ex, String msg, Object param1) {
        if (this.logger.isLoggable(DEBUG)) {
            this.doLog(DEBUG, msg, ex, param1);
        }
    }

    public void debug(Throwable ex, String msg, Object param1, Object param2) {
        if (this.logger.isLoggable(DEBUG)) {
            this.doLog(DEBUG, msg, ex, param1, param2);
        }
    }

    public void debug(Throwable ex, String msg, Object param1, Object param2, Object param3) {
        if (this.logger.isLoggable(DEBUG)) {
            this.doLog(DEBUG, msg, ex, param1, param2, param3);
        }
    }

    public void debug(String msg, Object ... params) {
        if (this.logger.isLoggable(DEBUG)) {
            this.doLog(DEBUG, msg, null, params);
        }
    }

    public void debug(String msg, Object param1) {
        if (this.logger.isLoggable(DEBUG)) {
            this.doLog(DEBUG, msg, null, param1);
        }
    }

    public void debug(String msg, Object param1, Object param2) {
        if (this.logger.isLoggable(DEBUG)) {
            this.doLog(DEBUG, msg, null, param1, param2);
        }
    }

    public void debug(String msg, Object param1, Object param2, Object param3) {
        if (this.logger.isLoggable(DEBUG)) {
            this.doLog(DEBUG, msg, null, param1, param2, param3);
        }
    }

    public void trace(String msg) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(TRACE, msg, null, null);
        }
    }

    public void trace(Throwable ex, String msg, Object ... params) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(TRACE, msg, ex, params);
        }
    }

    public void trace(Throwable ex, String msg, Object param1) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(TRACE, msg, ex, param1);
        }
    }

    public void trace(Throwable ex, String msg, Object param1, Object param2) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(TRACE, msg, ex, param1, param2);
        }
    }

    public void trace(Throwable ex, String msg, Object param1, Object param2, Object param3) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(TRACE, msg, ex, param1, param2, param3);
        }
    }

    public void trace(String msg, Object ... params) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(TRACE, msg, null, params);
        }
    }

    public void trace(String msg, Object param1) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(TRACE, msg, null, param1);
        }
    }

    public void trace(String msg, Object param1, Object param2) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(TRACE, msg, null, param1, param2);
        }
    }

    public void trace(String msg, Object param1, Object param2, Object param3) {
        if (this.logger.isLoggable(TRACE)) {
            this.doLog(TRACE, msg, null, param1, param2, param3);
        }
    }

    static final class Level
    extends java.util.logging.Level {
        private static final long serialVersionUID = 2595049467798273809L;

        protected Level(String name, int value) {
            super(name, value);
        }
    }
}

