/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import javax.management.NotCompliantMBeanException;
import javax.net.ServerSocketFactory;
import org.jboss.xnio.ManagedServerSocket;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.Xnio;

final class ManagedServerSocketFactory
extends ServerSocketFactory {
    private final OptionMap optionMap;
    private final Xnio xnio;

    ManagedServerSocketFactory(Xnio xnio, OptionMap optionMap) {
        this.optionMap = optionMap;
        this.xnio = xnio;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        ManagedServerSocket serverSocket = new ManagedServerSocket(this.optionMap);
        try {
            serverSocket.setRegistration(this.xnio.registerMBean(serverSocket.getMBean()));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new IOException("Cannot register server MBean");
        }
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket serverSocket = this.createServerSocket();
        serverSocket.bind(new InetSocketAddress(port), this.optionMap.get(Options.BACKLOG, 0));
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        ServerSocket serverSocket = this.createServerSocket();
        serverSocket.bind(new InetSocketAddress(port), backlog == 0 ? this.optionMap.get(Options.BACKLOG, 0) : backlog);
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        ServerSocket serverSocket = this.createServerSocket();
        serverSocket.bind(new InetSocketAddress(ifAddress, port), backlog == 0 ? this.optionMap.get(Options.BACKLOG, 0) : backlog);
        return serverSocket;
    }
}

