/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.deployers;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.management.j2ee.ResourceAdapter;
import org.jboss.management.j2ee.ResourceAdapterModule;
import org.jboss.management.j2ee.deployers.AbstractVFSJSR77Deployer;
import org.jboss.management.j2ee.factory.FactoryUtils;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.RARDeploymentMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RarModuleJSR77Deployer
extends AbstractVFSJSR77Deployer<RARDeploymentMetaData> {
    public RarModuleJSR77Deployer() {
        super(RARDeploymentMetaData.class);
    }

    @Override
    protected void deployJsr77(MBeanServer server, VFSDeploymentUnit unit, RARDeploymentMetaData rdmd) throws Throwable {
        ConnectorMetaData metaData = rdmd.getConnectorMetaData();
        String rarName = unit.getSimpleName();
        ObjectName rarService = this.extractRootObjectName(server, (DeploymentUnit)unit, rdmd);
        ObjectName jsr77ModuleName = ResourceAdapterModule.create(server, FactoryUtils.findEarParent((DeploymentUnit)unit), rarName, unit.getRoot().toURL());
        RarModuleJSR77Deployer.putObjectName((DeploymentUnit)unit, ResourceAdapter.class.getName(), jsr77ModuleName);
        this.log.debug((Object)("Created module: " + jsr77ModuleName));
        ObjectName jsr77RAName = ResourceAdapter.create(server, this.getDisplayName(unit, metaData), jsr77ModuleName, rarService);
        RarModuleJSR77Deployer.putObjectName((DeploymentUnit)unit, rarService.getCanonicalName(), jsr77RAName);
    }

    @Override
    protected void undeployJsr77(MBeanServer server, VFSDeploymentUnit unit, RARDeploymentMetaData rdmd) {
        ObjectName rarService;
        ConnectorMetaData metaData = rdmd.getConnectorMetaData();
        ObjectName jsr77Name = RarModuleJSR77Deployer.removeObjectName((DeploymentUnit)unit, ResourceAdapter.class.getName());
        ResourceAdapter.destroy(server, this.getDisplayName(unit, metaData));
        this.log.debug((Object)("Destroy module: " + jsr77Name));
        if (jsr77Name != null) {
            ResourceAdapterModule.destroy(server, jsr77Name);
        }
        if ((rarService = this.extractRootObjectName(server, (DeploymentUnit)unit, rdmd)) != null) {
            RarModuleJSR77Deployer.removeObjectName((DeploymentUnit)unit, rarService.getCanonicalName());
        }
    }

    protected String getDisplayName(VFSDeploymentUnit unit, ConnectorMetaData metaData) {
        String displayName = metaData.getDescription().getDisplayName();
        if (displayName == null) {
            this.log.debug((Object)("ConnectorMetaData displayname is null: " + metaData));
            displayName = unit.getSimpleName() + " [MISSING-DISPLAY-NAME]";
        }
        return displayName;
    }
}

