/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEResource;
import org.jboss.management.j2ee.JNDIResourceMBean;
import org.jboss.management.j2ee.StateManagement;

public class JNDIResource
extends J2EEResource
implements JNDIResourceMBean {
    private static Logger log = Logger.getLogger(JNDIResource.class);
    private StateManagement mState;
    private ObjectName jndiServiceName;

    public static ObjectName create(MBeanServer mbeanServer, String resName, ObjectName jndiServiceName) {
        ObjectName j2eeServerName = J2EEDomain.getDomainServerName(mbeanServer);
        ObjectName jsr77Name = null;
        try {
            JNDIResource jndiRes = new JNDIResource(resName, j2eeServerName, jndiServiceName);
            jsr77Name = jndiRes.getObjectName();
            mbeanServer.registerMBean(jndiRes, jsr77Name);
            log.debug((Object)("Created JSR-77 JNDIResource: " + resName));
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 JNDIResource: " + resName), (Throwable)e);
        }
        return jsr77Name;
    }

    public static void destroy(MBeanServer mbeanServer, String resName) {
        try {
            J2EEManagedObject.removeObject(mbeanServer, J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "JNDIResource" + "," + "name=" + resName + "," + "*");
        }
        catch (Exception e) {
            log.debug((Object)("Could not destroy JSR-77 JNDIResource: " + resName), (Throwable)e);
        }
    }

    public JNDIResource(String resName, ObjectName mbeanServer, ObjectName jndiServiceName) throws MalformedObjectNameException, InvalidParentException {
        super("JNDIResource", resName, mbeanServer);
        log.debug((Object)("Service name: " + jndiServiceName));
        this.jndiServiceName = jndiServiceName;
        this.mState = new StateManagement(this);
    }

    public String[] getEventTypes() {
        return StateManagement.stateTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.stateTypes.length) {
            return StateManagement.stateTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public String getStateString() {
        return this.mState.getStateString();
    }

    public void mejbStart() {
        try {
            this.server.invoke(this.jndiServiceName, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            log.debug((Object)"Start of JNDI Resource failed", (Throwable)e);
        }
    }

    public void mejbStartRecursive() {
        this.mejbStart();
    }

    public void mejbStop() {
        try {
            this.server.invoke(this.jndiServiceName, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            log.debug((Object)"Stop of JNDI Resource failed", (Throwable)e);
        }
    }

    public void postCreation() {
        try {
            this.server.addNotificationListener(this.jndiServiceName, this.mState, null, null);
        }
        catch (JMException e) {
            log.debug((Object)"Failed to add notification listener", (Throwable)e);
        }
        this.sendNotification("j2ee.object.created", "JNDI Resource created");
    }

    public void preDestruction() {
        this.sendNotification("j2ee.object.deleted", "JNDI Resource destroyed");
        try {
            this.server.removeNotificationListener(this.jndiServiceName, this.mState);
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public String toString() {
        return "JNDIResource { " + super.toString() + " } [ " + " ]";
    }
}

