/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.sub;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.bootstrap.api.as.config.JBossASServerConfig;
import org.jboss.ejb3.embedded.impl.base.scanner.ClassPathEjbJarScanner;
import org.jboss.ejb3.embedded.sub.vfs.VirtualFileAssembly;
import org.jboss.embedded.api.server.JBossASEmbeddedServer;
import org.jboss.embedded.api.server.JBossASEmbeddedServerFactory;

public class JBossSubmersibleEJBContainer
extends EJBContainer {
    private JBossASEmbeddedServer server;
    private Context context;

    protected JBossSubmersibleEJBContainer(JBossASEmbeddedServer server, Context context) {
        this.server = server;
        this.context = context;
    }

    private static Class<?> cls(ClassLoader loader, String className) {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new EJBException((Exception)e);
        }
    }

    public void close() {
        try {
            this.server.shutdown();
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EJBContainer createEJBContainer(Map<?, ?> properties, URLClassLoader loader, String jbossHome, String serverName) throws EJBException {
        File[] deployments;
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        Object modules = JBossSubmersibleEJBContainer.property(properties, "javax.ejb.embeddable.modules");
        if (modules != null) {
            Class<?> componentType = modules.getClass().getComponentType();
            if (componentType == null) {
                deployments = new File[1];
                if (modules instanceof String) {
                    throw new EJBException("EJBTHREE-2221: using String for javax.ejb.embeddable.modules is NYI");
                }
                if (!(modules instanceof File)) throw new EJBException("EJB 3.1 FR 22.2.2.2: Illegal type " + modules.getClass() + " for " + "javax.ejb.embeddable.modules");
                deployments[0] = (File)modules;
            } else {
                if (componentType.equals(String.class)) {
                    throw new EJBException("EJBTHREE-2221: using String[] for javax.ejb.embeddable.modules is NYI");
                }
                if (!componentType.equals(File.class)) throw new EJBException("EJB 3.1 FR 22.2.2.2: Illegal component type " + componentType + " for " + "javax.ejb.embeddable.modules");
                deployments = (File[])modules;
            }
        } else {
            String[] candidates = ClassPathEjbJarScanner.getEjbJars();
            deployments = new File[candidates.length];
            for (int i = 0; i < candidates.length; ++i) {
                deployments[i] = new File(candidates[i]);
            }
        }
        String appName = JBossSubmersibleEJBContainer.property(properties, "javax.ejb.embeddable.appName", String.class);
        String bindAddress = System.getProperty("embedded.bind.address", "localhost");
        Thread.currentThread().setContextClassLoader(loader);
        JBossASEmbeddedServer server = JBossASEmbeddedServerFactory.createServer((ClassLoader)loader);
        JBossASServerConfig config = (JBossASServerConfig)server.getConfiguration();
        config.jbossHome(jbossHome);
        config.serverName(serverName);
        config.bindAddress(bindAddress);
        try {
            server.start();
            InitialContext context = new InitialContext();
            if (appName == null) {
                server.deploy(deployments);
                return new JBossSubmersibleEJBContainer(server, context);
            } else {
                VirtualFileAssembly assembly = new VirtualFileAssembly(appName + ".ear");
                assembly.addDirectory("META-INF");
                assembly.add("META-INF/jboss-classloading.xml", JBossSubmersibleEJBContainer.createJBossClassLoadingXML());
                for (File d : deployments) {
                    if (d.isFile()) {
                        assembly.addZip(d.getName(), d);
                        continue;
                    }
                    String name = d.getName();
                    if (!name.endsWith(".jar")) {
                        name = name + ".jar";
                    }
                    assembly.add(name, d);
                }
                server.deploy(new URL[]{assembly.getMountRoot().toURL()});
            }
            return new JBossSubmersibleEJBContainer(server, context);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createJBossClassLoadingXML() {
        try {
            File file = File.createTempFile("jboss-classloading", ".xml");
            PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.println("<classloading xmlns=\"urn:jboss:classloading:1.0\"");
                out.println("        domain=\"DefaultDomain\"");
                out.println("        export-all=\"NON_EMPTY\"");
                out.println("        import-all=\"true\"");
                out.println("        top-level-classloader=\"true\"");
                out.println("        >");
                out.println("</classloading>");
                out.flush();
            }
            finally {
                out.close();
            }
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create jboss-classloading.xml", e);
        }
    }

    public Context getContext() {
        return this.context;
    }

    private static Object property(Map<?, ?> properties, String key) {
        if (properties == null) {
            return null;
        }
        return properties.get(key);
    }

    private static <T> T property(Map<?, ?> properties, String key, Class<T> expectedType) {
        if (properties == null) {
            return null;
        }
        return expectedType.cast(properties.get(key));
    }
}

