/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.javaee.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.support.AbstractMappedMetaData;
import org.jboss.metadata.javaee.support.IdMetaDataImpl;

public class SecurityRolesMetaData
extends AbstractMappedMetaData<SecurityRoleMetaData> {
    private static final long serialVersionUID = 4551308976124434096L;
    private Map<String, Set<String>> principalVersusRolesMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> readOnlyPrincipalVersusRolesMap = Collections.unmodifiableMap(this.principalVersusRolesMap);

    public SecurityRolesMetaData() {
        super("role name for security role");
    }

    @Override
    protected void addNotification(SecurityRoleMetaData added) {
        super.addNotification(added);
        this.processSecurityRoleMetaData(added);
    }

    public Map<String, Set<String>> getPrincipalVersusRolesMap() {
        return this.readOnlyPrincipalVersusRolesMap;
    }

    @Deprecated
    public SecurityRolesMetaData getSecurityRolesByPrincipal(String userName) {
        if (userName == null) {
            throw new IllegalArgumentException("Null userName");
        }
        if (this.isEmpty()) {
            return null;
        }
        SecurityRolesMetaData result = new SecurityRolesMetaData();
        for (SecurityRoleMetaData role : this) {
            if (!role.hasPrincipal(userName)) continue;
            result.add(role);
        }
        return result;
    }

    public Set<String> getSecurityRoleNamesByPrincipal(String userName) {
        if (userName == null) {
            throw new IllegalArgumentException("Null userName");
        }
        Set<String> roles = this.readOnlyPrincipalVersusRolesMap.get(userName);
        if (roles == null) {
            return Collections.emptySet();
        }
        return roles;
    }

    @Override
    public void merge(IdMetaDataImpl override, IdMetaDataImpl original) {
        SecurityRoleMetaData to;
        super.merge(override, original);
        SecurityRolesMetaData roles1 = (SecurityRolesMetaData)override;
        SecurityRolesMetaData roles0 = (SecurityRolesMetaData)original;
        if (roles0 != null) {
            for (SecurityRoleMetaData sr : roles0) {
                to = (SecurityRoleMetaData)this.get(sr.getRoleName());
                if (to != null) {
                    to.merge(sr, null);
                    continue;
                }
                this.add(sr);
            }
        }
        if (roles1 != null) {
            for (SecurityRoleMetaData sr : roles1) {
                to = (SecurityRoleMetaData)this.get(sr.getRoleName());
                if (to != null) {
                    to.merge(sr, null);
                    continue;
                }
                this.add(sr);
            }
        }
        this.rebuildPrincipalsVersusRolesMap();
    }

    private void processSecurityRoleMetaData(SecurityRoleMetaData roleMetaData) {
        Set<String> principals = roleMetaData.getPrincipals();
        if (principals == null) {
            return;
        }
        for (String principal : principals) {
            Set<String> roles = this.principalVersusRolesMap.get(principal);
            if (roles == null) {
                roles = new HashSet<String>();
                this.principalVersusRolesMap.put(principal, roles);
            }
            roles.add(roleMetaData.getRoleName());
        }
    }

    private void rebuildPrincipalsVersusRolesMap() {
        this.principalVersusRolesMap.clear();
        for (SecurityRoleMetaData roleMetaData : this) {
            this.processSecurityRoleMetaData(roleMetaData);
        }
    }

    @Override
    protected void removeNotification(SecurityRoleMetaData removed) {
        super.removeNotification(removed);
        Set<String> principals = removed.getPrincipals();
        if (principals == null) {
            return;
        }
        for (String principal : principals) {
            Set<String> roles = this.principalVersusRolesMap.get(principal);
            if (roles == null) continue;
            roles.remove(removed.getRoleName());
        }
    }
}

