/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.deployers.pojo;

import org.hornetq.api.core.management.ObjectNameBuilder;
import org.hornetq.jms.server.config.TopicConfiguration;
import org.jboss.as.integration.hornetq.deployers.pojo.HornetQJMSDeployment;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQTopicDeployment
extends HornetQJMSDeployment<TopicConfiguration> {
    private static final Logger log = Logger.getLogger(HornetQTopicDeployment.class);

    @Override
    public void start() throws Exception {
        log.debug((Object)("Deploying Topic " + ((TopicConfiguration)this.config).getName()));
        try {
            this.jmsServer.createTopic(false, ((TopicConfiguration)this.config).getName(), ((TopicConfiguration)this.config).getBindings());
            this.registerControlReference(ObjectNameBuilder.DEFAULT.getJMSTopicObjectName(((TopicConfiguration)this.config).getName()));
        }
        catch (Exception e) {
            log.warn((Object)("Error deploying Topic: " + ((TopicConfiguration)this.config).getName()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void stop() throws Exception {
        log.debug((Object)("Undeploying Topic " + ((TopicConfiguration)this.config).getName()));
        try {
            this.unregisterControlReference(ObjectNameBuilder.DEFAULT.getJMSTopicObjectName(((TopicConfiguration)this.config).getName()));
            this.jmsServer.removeTopicFromJNDI(((TopicConfiguration)this.config).getName());
        }
        catch (Exception e) {
            log.warn((Object)("Error destroying Topic: " + ((TopicConfiguration)this.config).getName()), (Throwable)e);
        }
    }
}

