/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.deployers.pojo;

import org.hornetq.api.core.management.ObjectNameBuilder;
import org.hornetq.jms.server.config.JMSQueueConfiguration;
import org.jboss.as.integration.hornetq.deployers.pojo.HornetQJMSDeployment;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQQueueDeployment
extends HornetQJMSDeployment<JMSQueueConfiguration> {
    private static final Logger log = Logger.getLogger(HornetQQueueDeployment.class);

    @Override
    public void start() throws Exception {
        try {
            log.debug((Object)("Deploying Queue " + ((JMSQueueConfiguration)this.config).getName()));
            this.jmsServer.createQueue(false, ((JMSQueueConfiguration)this.config).getName(), ((JMSQueueConfiguration)this.config).getSelector(), ((JMSQueueConfiguration)this.config).isDurable(), ((JMSQueueConfiguration)this.config).getBindings());
            this.registerControlReference(ObjectNameBuilder.DEFAULT.getJMSQueueObjectName(((JMSQueueConfiguration)this.config).getName()));
        }
        catch (Exception e) {
            log.warn((Object)("Error deploying Queue: " + ((JMSQueueConfiguration)this.config).getName()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void stop() throws Exception {
        log.debug((Object)("Undeploying queue " + ((JMSQueueConfiguration)this.config).getName()));
        this.unregisterControlReference(ObjectNameBuilder.DEFAULT.getJMSQueueObjectName(((JMSQueueConfiguration)this.config).getName()));
        this.jmsServer.removeQueueFromJNDI(((JMSQueueConfiguration)this.config).getName());
    }
}

