/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.deployers;

import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.core.config.Configuration;
import org.jboss.as.integration.hornetq.deployers.pojo.HornetQCoreDeployment;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQCoreConfigRealDeployer
extends AbstractSimpleRealDeployer<Configuration> {
    private final AtomicInteger idGenerator = new AtomicInteger(1);

    public HornetQCoreConfigRealDeployer() {
        super(Configuration.class);
        this.addOutput(BeanMetaData.class);
        this.addInput(JBossMetaData.class);
    }

    public void deploy(DeploymentUnit unit, Configuration config) throws DeploymentException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Deploying unit: " + unit + " with config " + config));
        }
        String name = "HornetQCoreDeployment::" + this.idGenerator.incrementAndGet();
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)name, (String)HornetQCoreDeployment.class.getName());
        builder.addPropertyMetaData("name", name);
        builder.addPropertyMetaData("server", builder.createInject((Object)"HornetQServer"));
        builder.addPropertyMetaData("config", (Object)config);
        BeanMetaData bean = builder.getBeanMetaData();
        unit.addAttachment(name, (Object)bean);
    }
}

