/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.weld.plugins.annotated;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import org.jboss.kernel.weld.metadata.api.annotations.Weld;
import org.jboss.kernel.weld.plugins.annotated.MDRAnnotated;
import org.jboss.kernel.weld.plugins.annotated.MDRAnnotatedType;
import org.jboss.metadata.spi.MetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MDRAnnotatedMember<X>
extends MDRAnnotated
implements AnnotatedMember<X> {
    private MDRAnnotatedType<X> owner;
    private volatile AnnotatedType<X> declaringOwner;
    private static final Set<Annotation> EMPTY_ANNOTATIONS = Collections.unmodifiableSet(Collections.emptySet());

    public MDRAnnotatedMember(MDRAnnotatedType<X> owner, Annotated delegate, MetaData metaData) {
        super(delegate, metaData);
        if (owner == null) {
            throw new IllegalArgumentException("Null owner");
        }
        this.owner = owner;
    }

    AnnotatedMember<X> getDelegate() {
        return (AnnotatedMember)super.getDelegate();
    }

    public AnnotatedType<X> getDeclaringType() {
        AnnotatedType declaring = this.getDelegate().getDeclaringType();
        if (declaring.getJavaClass() != this.owner.getJavaClass()) {
            if (this.declaringOwner == null) {
                MDRAnnotatedType type = new MDRAnnotatedType(declaring, this.owner.getMetaData());
                this.declaringOwner = type;
            }
            return this.declaringOwner;
        }
        return this.owner;
    }

    public boolean isStatic() {
        return this.getDelegate().isStatic();
    }

    @Override
    protected Set<Annotation> trimInjectIfWeldAbsent(Set<Annotation> annotations) {
        if (!super.isAnnotationPresent(Weld.class) && super.isAnnotationPresent(Inject.class)) {
            if (annotations.size() == 1) {
                return EMPTY_ANNOTATIONS;
            }
            HashSet<Annotation> result = new HashSet<Annotation>();
            for (Annotation ann : annotations) {
                if (ann.annotationType() == Inject.class) continue;
                result.add(ann);
            }
            return result;
        }
        return annotations;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        if (annotationType.equals(Inject.class) && !super.isAnnotationPresent(Weld.class)) {
            return false;
        }
        return super.isAnnotationPresent(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        if (annotationType.equals(Inject.class) && !this.isAnnotationPresent(Weld.class)) {
            return null;
        }
        return super.getAnnotation(annotationType);
    }
}

