/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class JBossWSBusApplicationContext
extends BusApplicationContext {
    private static final String JBWS_INTEGRATION_CXF_CFG_FILE = "META-INF/cxf/jbossws-cxf.xml";
    private static final String JBWS_CXF_EXT_CFG_FILE = "classpath*:META-INF/cxf/cxf-extension-jbossws.xml";
    private static final String DEFAULT_CXF_EXT_CFG_FILE = "classpath*:META-INF/cxf/cxf.extension";
    private final boolean jbwsIncludeDefaults;
    private final boolean ready;

    public JBossWSBusApplicationContext(String[] cf, boolean include, ApplicationContext parent) {
        super(cf, false, parent);
        this.jbwsIncludeDefaults = include;
        this.ready = true;
        this.refresh();
    }

    public JBossWSBusApplicationContext(URL[] url, boolean include, ApplicationContext parent) {
        super(url, false, parent);
        this.jbwsIncludeDefaults = include;
        this.ready = true;
        this.refresh();
    }

    protected Resource[] getConfigResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.ready) {
            Resource[] superResources;
            if (this.jbwsIncludeDefaults) {
                try {
                    Resource[] exts;
                    PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(Thread.currentThread().getContextClassLoader());
                    Collections.addAll(resources, resolver.getResources(JBWS_INTEGRATION_CXF_CFG_FILE));
                    Collections.addAll(resources, resolver.getResources(JBWS_CXF_EXT_CFG_FILE));
                    for (Resource r : exts = resolver.getResources(DEFAULT_CXF_EXT_CFG_FILE)) {
                        InputStream is = r.getInputStream();
                        BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        String line = rd.readLine();
                        while (line != null) {
                            if (!"".equals(line)) {
                                resources.add(resolver.getResource(line));
                            }
                            line = rd.readLine();
                        }
                        is.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if ((superResources = super.getConfigResources()) != null) {
                Collections.addAll(resources, superResources);
            }
        }
        return resources.isEmpty() ? null : resources.toArray(new Resource[resources.size()]);
    }
}

