/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import org.jboss.metadata.annotation.creator.AbstractComponentProcessor;
import org.jboss.metadata.annotation.creator.AbstractProcessor;
import org.jboss.metadata.annotation.creator.DeclareRolesProcessor;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ejb.DenyAllProcessor;
import org.jboss.metadata.annotation.creator.ejb.EjbClassThreadLocal;
import org.jboss.metadata.annotation.creator.ejb.EjbNameThreadLocal;
import org.jboss.metadata.annotation.creator.ejb.InterceptorsProcessor;
import org.jboss.metadata.annotation.creator.ejb.PermitAllProcessor;
import org.jboss.metadata.annotation.creator.ejb.RolesAllowedProcessor;
import org.jboss.metadata.annotation.creator.ejb.RunAsProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

public abstract class AbstractEnterpriseBeanProcessor<MD extends EnterpriseBeanMetaData>
extends AbstractComponentProcessor<MD>
implements Processor<EjbJar3xMetaData, Class<?>> {
    protected abstract MD create(Class<?> var1);

    protected AbstractEnterpriseBeanProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addTypeProcessor(new RunAsProcessor(finder));
        this.addTypeProcessor((Processor)new DeclareRolesProcessor(finder));
        this.addMethodProcessor(new DenyAllProcessor(finder));
        this.addTypeProcessor(new RolesAllowedProcessor(finder));
        this.addMethodProcessor(new RolesAllowedProcessor(finder));
        this.addTypeProcessor(new PermitAllProcessor(finder));
        this.addMethodProcessor(new PermitAllProcessor(finder));
        this.addTypeProcessor(new InterceptorsProcessor(finder));
        this.addMethodProcessor(new InterceptorsProcessor(finder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(EjbJar3xMetaData ejbJarMetaData, Class<?> beanClass) {
        MD beanMetaData = this.create(beanClass);
        if (beanMetaData == null) {
            return;
        }
        try {
            SecurityRolesMetaData securityRoles;
            EjbNameThreadLocal.ejbName.set(((EnterpriseBeanMetaData)beanMetaData).getEjbName());
            EjbClassThreadLocal.ejbClass.set(beanClass);
            EnvironmentRefsGroupMetaData env = (EnvironmentRefsGroupMetaData)((EnterpriseBeanMetaData)beanMetaData).getJndiEnvironmentRefsGroup();
            if (env == null) {
                env = new EnvironmentRefsGroupMetaData();
                ((EnterpriseBeanMetaData)beanMetaData).setJndiEnvironmentRefsGroup((Environment)env);
            }
            super.process(env, beanClass);
            if (ejbJarMetaData.getEnterpriseBeans() == null) {
                ejbJarMetaData.setEnterpriseBeans(new EnterpriseBeansMetaData());
            }
            ejbJarMetaData.getEnterpriseBeans().add(beanMetaData);
            this.processClass(beanMetaData, beanClass);
            AssemblyDescriptorMetaData assembly = ejbJarMetaData.getAssemblyDescriptor();
            if (assembly == null) {
                assembly = new AssemblyDescriptorMetaData();
                ejbJarMetaData.setAssemblyDescriptor(assembly);
            }
            if ((securityRoles = assembly.getSecurityRoles()) == null) {
                securityRoles = new SecurityRolesMetaData();
                assembly.setSecurityRoles(securityRoles);
            }
            super.processClass((Object)securityRoles, beanClass);
            ExcludeListMetaData excludes = assembly.getExcludeList();
            if (excludes == null) {
                excludes = new ExcludeListMetaData();
                assembly.setExcludeList(excludes);
            }
            super.processClass((Object)excludes, beanClass);
            MethodPermissionsMetaData permissions = assembly.getMethodPermissions();
            if (permissions == null) {
                permissions = new MethodPermissionsMetaData();
                assembly.setMethodPermissions(permissions);
            }
            super.processClass((Object)permissions, beanClass);
            InterceptorBindingsMetaData interceptors = assembly.getInterceptorBindings();
            if (interceptors == null) {
                interceptors = new InterceptorBindingsMetaData();
                assembly.setInterceptorBindings(interceptors);
            }
            super.processClass((Object)interceptors, beanClass);
        }
        finally {
            EjbNameThreadLocal.ejbName.set(null);
            EjbClassThreadLocal.ejbClass.set(null);
        }
    }

    public abstract Collection<Class<? extends Annotation>> getAnnotationTypes();

    public Collection<Class<? extends Annotation>> getProcessedAnnotations(AbstractProcessor.Scope scope) {
        if (scope == AbstractProcessor.Scope.TYPE) {
            return this.getAnnotationTypes();
        }
        return Collections.EMPTY_SET;
    }
}

