/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.client;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.client.AppClientLauncher;
import org.jboss.client.ReflectionLauncher;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppClientMain {
    private static final Logger log = Logger.getLogger(AppClientMain.class);
    public static final String JBOSS_CLIENT_PARAM = "-jbossclient";
    public static final String J2EE_CLIENT_PARAM = "-j2ee.clientName";
    public static final String LAUNCHERS_PARAM = "-launchers";
    public static String[] DEFAULT_LAUNCHERS = new String[]{ReflectionLauncher.class.getName()};

    public static void main(String[] args) throws Exception {
        log.debug((Object)"System Properties");
        Properties sysprops = System.getProperties();
        for (Object key : sysprops.keySet()) {
            log.debug((Object)("  " + key + "=" + sysprops.getProperty((String)key)));
        }
        String clientClass = null;
        String clientName = null;
        ArrayList<String> newArgs = new ArrayList<String>();
        String[] launchers = DEFAULT_LAUNCHERS;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            log.debug((Object)("arg=" + arg));
            if (arg.equals(JBOSS_CLIENT_PARAM)) {
                clientClass = args[i + 1];
                ++i;
                continue;
            }
            if (arg.equals(J2EE_CLIENT_PARAM)) {
                clientName = args[i + 1];
                System.setProperty("j2ee.clientName", clientName);
                log.info((Object)("j2ee.clientName=" + clientName));
                ++i;
                continue;
            }
            if (arg.equals(LAUNCHERS_PARAM)) {
                launchers = args[i + 1].split(",");
                log.info((Object)("-launchers=" + args[i + 1]));
                ++i;
                continue;
            }
            newArgs.add(args[i]);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = AppClientMain.class.getClassLoader();
        }
        if (clientClass == null) {
            clientClass = AppClientMain.getMainClassName(loader);
            throw new IllegalArgumentException("Neither a Main-Class was found in the manifest, nor was a -jbossclient specified");
        }
        if (clientName == null) {
            clientName = AppClientMain.getClientName(loader);
        }
        String[] mainArgs = new String[newArgs.size()];
        newArgs.toArray(mainArgs);
        for (String launcherName : launchers) {
            try {
                Class<?> launcherClass = loader.loadClass(launcherName);
                AppClientLauncher launcher = (AppClientLauncher)launcherClass.newInstance();
                launcher.launch(clientClass, clientName, mainArgs);
                break;
            }
            catch (Throwable t) {
                log.warn((Object)("Failed to launch using: " + launcherName), t);
            }
        }
    }

    private static String getClientName(ClassLoader loader) throws Exception {
        String clientName = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        URL appXmlURL = loader.getResource("META-INF/application-client.xml");
        if (appXmlURL != null) {
            InputStream is = appXmlURL.openStream();
            Document appXml = builder.parse(is);
            is.close();
            Element root = appXml.getDocumentElement();
            clientName = root.getAttribute("id");
            if (clientName != null) {
                return clientName;
            }
        }
        URL jbossXmlURL = loader.getResource("META-INF/jboss-client.xml");
        if (appXmlURL != null) {
            InputStream is = jbossXmlURL.openStream();
            Document jbossXml = builder.parse(is);
            is.close();
            Element root = jbossXml.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int n = 0; n < children.getLength(); ++n) {
                Node node = children.item(n);
                if (!node.getLocalName().equals("jndi-name")) continue;
                clientName = node.getNodeValue();
                return clientName;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMainClassName(ClassLoader loader) throws Exception {
        Manifest mf;
        URL mfURL = loader.getResource("META-INF/MANIFEST.MF");
        if (mfURL == null) {
            return null;
        }
        InputStream is = mfURL.openStream();
        try {
            mf = new Manifest(is);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
        is.close();
        Attributes attrs = mf.getMainAttributes();
        String mainClassName = attrs.getValue(Attributes.Name.MAIN_CLASS);
        return mainClassName;
    }
}

