/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.scheduler;

import java.security.AccessController;
import java.security.PrivilegedAction;

class TCLActions {
    TCLActions() {
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
        return loader;
    }

    static ClassLoader getClassLoader(Class c) {
        GetClassLoaderAction action = new GetClassLoaderAction(c);
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(action);
        return loader;
    }

    static void setContextClassLoader(ClassLoader loader) {
        SetTCLAction action = new SetTCLAction(loader);
        AccessController.doPrivileged(action);
    }

    private static class SetTCLAction
    implements PrivilegedAction {
        ClassLoader loader;

        SetTCLAction(ClassLoader loader) {
            this.loader = loader;
        }

        public Object run() {
            Thread.currentThread().setContextClassLoader(this.loader);
            this.loader = null;
            return null;
        }
    }

    private static class GetClassLoaderAction
    implements PrivilegedAction {
        Class c;

        GetClassLoaderAction(Class c) {
            this.c = c;
        }

        public Object run() {
            ClassLoader loader = this.c.getClassLoader();
            this.c = null;
            return loader;
        }
    }

    private static class GetTCLAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        public Object run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }
    }
}

