/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.alarm;

import java.util.HashMap;
import java.util.Map;
import org.jboss.monitor.alarm.Alarm;
import org.jboss.monitor.alarm.AlarmTableNotification;

public class AlarmHelper
implements Alarm {
    private AlarmHelper() {
    }

    public static String getSeverityAsString(int severity) {
        if (severity < 0 || severity > 5) {
            severity = 5;
        }
        return SEVERITY_STRINGS[severity];
    }

    public static String getStateAsString(int alarmState) {
        if (alarmState < 0 || alarmState > 3) {
            alarmState = 3;
        }
        return STATE_STRINGS[alarmState];
    }

    public static Map getAlarmTableNotificationStats(AlarmTableNotification[] almtab) {
        int stateCleared = 0;
        int stateChanged = 0;
        int stateCreated = 0;
        int stateNone = 0;
        int severityNormal = 0;
        int severityWarning = 0;
        int severityMinor = 0;
        int severityMajor = 0;
        int severityCritical = 0;
        int severityUnknown = 0;
        if (almtab != null) {
            block12: for (int i = 0; i < almtab.length; ++i) {
                AlarmTableNotification atn = almtab[i];
                switch (atn.getAlarmState()) {
                    case 0: {
                        ++stateCleared;
                        break;
                    }
                    case 1: {
                        ++stateChanged;
                        break;
                    }
                    case 2: {
                        ++stateCreated;
                        break;
                    }
                    default: {
                        ++stateNone;
                    }
                }
                switch (atn.getSeverity()) {
                    case 0: {
                        ++severityNormal;
                        continue block12;
                    }
                    case 1: {
                        ++severityWarning;
                        continue block12;
                    }
                    case 2: {
                        ++severityMinor;
                        continue block12;
                    }
                    case 3: {
                        ++severityMajor;
                        continue block12;
                    }
                    case 4: {
                        ++severityCritical;
                        continue block12;
                    }
                    default: {
                        ++severityUnknown;
                    }
                }
            }
            HashMap<String, Integer> stats = new HashMap<String, Integer>();
            stats.put(AlarmHelper.getSeverityAsString(0), new Integer(severityNormal));
            stats.put(AlarmHelper.getSeverityAsString(1), new Integer(severityWarning));
            stats.put(AlarmHelper.getSeverityAsString(2), new Integer(severityMinor));
            stats.put(AlarmHelper.getSeverityAsString(3), new Integer(severityMajor));
            stats.put(AlarmHelper.getSeverityAsString(4), new Integer(severityCritical));
            stats.put(AlarmHelper.getSeverityAsString(5), new Integer(severityUnknown));
            stats.put(AlarmHelper.getStateAsString(0), new Integer(stateCleared));
            stats.put(AlarmHelper.getStateAsString(1), new Integer(stateChanged));
            stats.put(AlarmHelper.getStateAsString(2), new Integer(stateCreated));
            stats.put(AlarmHelper.getStateAsString(3), new Integer(stateNone));
            return stats;
        }
        return null;
    }
}

