/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier.factory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.jboss.verifier.Section;
import org.jboss.verifier.event.VerificationEvent;
import org.jboss.verifier.event.VerificationEventGenerator;
import org.jboss.verifier.factory.VerificationEventFactory;

public class DefaultEventFactory
implements VerificationEventFactory {
    public static final String DEFAULT_MESSAGE_BUNDLE = "/org/jboss/verifier/DefaultMessages.properties";
    private Map msgTable = null;
    private String msgBundle;

    public DefaultEventFactory() {
        this.msgBundle = DEFAULT_MESSAGE_BUNDLE;
        this.msgTable = this.loadErrorMessages();
    }

    public DefaultEventFactory(String msgBundle) {
        this.msgBundle = "/org/jboss/verifier/" + msgBundle;
        this.msgTable = this.loadErrorMessages();
    }

    public VerificationEvent createSpecViolationEvent(VerificationEventGenerator source, Section section) {
        VerificationEvent event = new VerificationEvent(source);
        event.setState("WARNING");
        event.setSection(section);
        event.setMessage((String)this.msgTable.get(section.getSection()));
        return event;
    }

    public VerificationEvent createBeanVerifiedEvent(VerificationEventGenerator source) {
        VerificationEvent event = new VerificationEvent(source);
        event.setState("OK");
        event.setMessage("Verified.");
        return event;
    }

    public String getMessageBundle() {
        return this.msgBundle;
    }

    private Map loadErrorMessages() {
        try {
            InputStream in = this.getClass().getResourceAsStream(this.msgBundle);
            Properties props = new Properties();
            props.load(in);
            return props;
        }
        catch (IOException e) {
            throw new MissingResourceException("I/O failure: " + e.getMessage(), this.msgBundle, "");
        }
        catch (NullPointerException e) {
            throw new MissingResourceException("Resource not found.", this.msgBundle, "");
        }
    }
}

