/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.net.URL;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.vfs.VirtualFile;
import org.w3c.dom.Element;

public final class JDBCXmlFileLoader {
    private final Container container;
    private final Logger log;

    public JDBCXmlFileLoader(Container con, Logger log) {
        this.container = con;
        this.log = log;
    }

    public JDBCApplicationMetaData load() throws DeploymentException {
        JDBCApplicationMetaData jamd = new JDBCApplicationMetaData(this.container.getBeanMetaData().getApplicationMetaData(), this.container.getClassLoader());
        URL stdJDBCUrl = this.container.getClassLoader().getResource("standardjbosscmp-jdbc.xml");
        if (stdJDBCUrl == null) {
            throw new DeploymentException("No standardjbosscmp-jdbc.xml found");
        }
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("Loading standardjbosscmp-jdbc.xml : " + stdJDBCUrl.toString()));
        }
        Element stdJDBCElement = XmlFileLoader.getDocument(stdJDBCUrl, true).getDocumentElement();
        jamd = new JDBCApplicationMetaData(stdJDBCElement, jamd);
        URL jdbcUrl = null;
        VirtualFile dd = this.container.getDeploymentUnit().getMetaDataFile("jbosscmp-jdbc.xml");
        if (dd != null) {
            try {
                jdbcUrl = dd.toURL();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create URL for " + dd.getPathName(), e);
            }
        }
        if (jdbcUrl != null) {
            if (debug) {
                this.log.debug((Object)(jdbcUrl.toString() + " found. Overriding defaults"));
            }
            Element jdbcElement = XmlFileLoader.getDocument(jdbcUrl, true).getDocumentElement();
            jamd = new JDBCApplicationMetaData(jdbcElement, jamd);
        }
        return jamd;
    }
}

