/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.ejbql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.ejb.plugins.cmp.bridge.EntityBridge;

public final class Catalog {
    private final Map entityByAbstractSchemaName = new HashMap();
    private final Map entityByEJBName = new HashMap();
    private final Map entityByInterface = new HashMap();

    public void addEntity(EntityBridge entityBridge) {
        Class local;
        this.entityByAbstractSchemaName.put(entityBridge.getAbstractSchemaName(), entityBridge);
        this.entityByEJBName.put(entityBridge.getEntityName(), entityBridge);
        Class remote = entityBridge.getRemoteInterface();
        if (remote != null) {
            this.entityByInterface.put(remote, entityBridge);
        }
        if ((local = entityBridge.getLocalInterface()) != null) {
            this.entityByInterface.put(local, entityBridge);
        }
    }

    public EntityBridge getEntityByAbstractSchemaName(String abstractSchemaName) {
        return (EntityBridge)this.entityByAbstractSchemaName.get(abstractSchemaName);
    }

    public EntityBridge getEntityByInterface(Class intf) {
        return (EntityBridge)this.entityByInterface.get(intf);
    }

    public EntityBridge getEntityByEJBName(String ejbName) {
        return (EntityBridge)this.entityByEJBName.get(ejbName);
    }

    public int getEntityCount() {
        return this.entityByEJBName.size();
    }

    public Set getEJBNames() {
        return Collections.unmodifiableSet(this.entityByEJBName.keySet());
    }
}

