/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.StatelessSessionEnterpriseContext;
import org.jboss.ejb.plugins.AbstractInstancePool;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class SingletonStatelessSessionInstancePool
extends AbstractInstancePool {
    EnterpriseContext ctx;
    boolean inUse = false;
    boolean isSynchronized = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EnterpriseContext get() throws Exception {
        boolean intr = false;
        try {
            while (this.inUse && this.isSynchronized) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    intr = true;
                }
            }
            if (this.ctx == null) {
                try {
                    this.ctx = this.create(this.getContainer().createBeanClassInstance());
                }
                catch (InstantiationException e) {
                    throw new EJBException("Could not instantiate bean", (Exception)e);
                }
                catch (IllegalAccessException e) {
                    throw new EJBException("Could not instantiate bean", (Exception)e);
                }
            }
            this.inUse = true;
            EnterpriseContext enterpriseContext = this.ctx;
            Object var4_6 = null;
            if (intr) {
                Thread.currentThread().interrupt();
            }
            return enterpriseContext;
        }
        catch (Throwable throwable) {
            block10: {
                Object var4_7 = null;
                if (!intr) break block10;
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }

    public synchronized void free(EnterpriseContext ctx) {
        this.inUse = false;
        this.notifyAll();
    }

    public synchronized void discard(EnterpriseContext ctx) {
        try {
            ctx.discard();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.inUse = false;
        this.notifyAll();
    }

    public void add() throws Exception {
    }

    public int getCurrentSize() {
        return 1;
    }

    public int getMaxSize() {
        return 1;
    }

    public long getAvailableCount() {
        return 1L;
    }

    public void importXml(Element element) throws DeploymentException {
        Element synch = MetaData.getUniqueChild((Element)element, (String)"Synchronized");
        this.isSynchronized = Boolean.valueOf(MetaData.getElementContent((Element)synch));
    }

    protected EnterpriseContext create(Object instance) throws Exception {
        return new StatelessSessionEnterpriseContext(instance, this.getContainer());
    }
}

