/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.deployers;

import java.util.Collection;
import java.util.HashSet;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.AnnotationMetaDataDeployer;
import org.jboss.metadata.annotation.creator.ejb.InterceptorMetaDataCreator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.IdMetaDataImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedJBossMetaDataDeployer
extends AbstractDeployer {
    public static final String EJB_MERGED_ATTACHMENT_NAME = "merged." + JBossMetaData.class.getName();

    public MergedJBossMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(EjbJarMetaData.class);
        this.addInput(JBossMetaData.class);
        this.addInput(AnnotationMetaDataDeployer.EJB_ANNOTATED_ATTACHMENT_NAME);
        this.setOutput(JBossMetaData.class);
        this.addOutput(EJB_MERGED_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)unit.getAttachment(EjbJarMetaData.class);
        JBossMetaData metaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        String key = AnnotationMetaDataDeployer.EJB_ANNOTATED_ATTACHMENT_NAME;
        JBossMetaData annotatedMetaData = (JBossMetaData)unit.getAttachment(key, JBossMetaData.class);
        if (ejbJarMetaData == null && metaData == null && annotatedMetaData == null) {
            return;
        }
        JBoss50MetaData specMetaData = new JBoss50MetaData();
        if (ejbJarMetaData != null) {
            specMetaData.merge(null, ejbJarMetaData);
            if (annotatedMetaData != null) {
                JBoss50MetaData specMerged = new JBoss50MetaData();
                specMerged.merge((JBossMetaData)specMetaData, annotatedMetaData);
                specMetaData = specMerged;
            }
        } else {
            specMetaData = annotatedMetaData;
        }
        JBossMetaData mergedMetaData = new JBossMetaData();
        mergedMetaData.merge(metaData, (JBossMetaData)specMetaData);
        DeploymentUnit topUnit = unit.getTopLevel();
        if (topUnit != null && topUnit.getAttachment(JBossAppMetaData.class) != null) {
            SecurityRolesMetaData earSecurityRolesMetaData;
            JBossAppMetaData earMetaData = (JBossAppMetaData)topUnit.getAttachment(JBossAppMetaData.class);
            String securityDomain = earMetaData.getSecurityDomain();
            if (securityDomain != null && mergedMetaData.getSecurityDomain() == null) {
                mergedMetaData.setSecurityDomain(securityDomain);
            }
            if ((earSecurityRolesMetaData = earMetaData.getSecurityRoles()) != null) {
                SecurityRolesMetaData mergedSecurityRolesMetaData;
                JBossAssemblyDescriptorMetaData jadmd = mergedMetaData.getAssemblyDescriptor();
                if (jadmd == null) {
                    jadmd = new JBossAssemblyDescriptorMetaData();
                    mergedMetaData.setAssemblyDescriptor(jadmd);
                }
                if ((mergedSecurityRolesMetaData = jadmd.getSecurityRoles()) == null) {
                    jadmd.setSecurityRoles(earSecurityRolesMetaData);
                }
                if (mergedSecurityRolesMetaData != null) {
                    mergedSecurityRolesMetaData.merge((IdMetaDataImpl)mergedSecurityRolesMetaData, (IdMetaDataImpl)earSecurityRolesMetaData);
                }
            }
        }
        Collection interceptorClassNames = JBossMetaData.getAllInterceptorClasses((JBossMetaData)mergedMetaData);
        Collection<Class<?>> interceptorClasses = null;
        try {
            interceptorClasses = this.loadClasses(unit.getClassLoader(), interceptorClassNames);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DeploymentException("Exception while loading interceptor classes for unit " + unit.getName(), (Throwable)cnfe);
        }
        DefaultAnnotationFinder annotationFinder = new DefaultAnnotationFinder();
        InterceptorMetaDataCreator interceptorMetaDataCreator = new InterceptorMetaDataCreator((AnnotationFinder)annotationFinder);
        InterceptorsMetaData annotatedInterceptorsMetaData = interceptorMetaDataCreator.create(interceptorClasses);
        InterceptorsMetaData mergedInterceptorsMetaData = new InterceptorsMetaData();
        mergedInterceptorsMetaData.merge(mergedMetaData.getInterceptors(), annotatedInterceptorsMetaData);
        mergedMetaData.setInterceptors(mergedInterceptorsMetaData);
        unit.getTransientManagedObjects().addAttachment(JBossMetaData.class, (Object)mergedMetaData);
        unit.addAttachment(EJB_MERGED_ATTACHMENT_NAME, (Object)mergedMetaData, JBossMetaData.class);
    }

    private Collection<Class<?>> loadClasses(ClassLoader cl, Iterable<String> classNames) throws ClassNotFoundException {
        HashSet interceptorClasses = new HashSet();
        for (String interceptorClassName : classNames) {
            interceptorClasses.add(cl.loadClass(interceptorClassName));
        }
        return interceptorClasses;
    }
}

