/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class LegacyWebXmlLessDeployer
extends AbstractDeployer {
    public LegacyWebXmlLessDeployer() {
        this.addInput(WebMetaData.class);
        this.addInput(JBossWebMetaData.class);
        this.setOutput(JBossWebMetaData.class);
        this.setStage(DeploymentStages.POST_PARSE);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (unit.getSimpleName().endsWith(".war")) {
            if (unit.isAttachmentPresent(JBossWebMetaData.class)) {
                return;
            }
            if (!(unit instanceof VFSDeploymentUnit)) {
                return;
            }
            String bundleSymbolicName = (String)unit.getAttachment("org.jboss.osgi.bundle.symbolic.name", String.class);
            if (bundleSymbolicName != null) {
                this.log.debug((Object)("Ignore OSGi webapp: " + bundleSymbolicName));
                return;
            }
            this.log.debug((Object)("Web archive doesn't contain web.xml: " + unit.getName()));
            unit.getTransientManagedObjects().addAttachment(JBossWebMetaData.class, (Object)new JBossWebMetaData());
        }
    }
}

