/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invalidation;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.cache.invalidation.BatchInvalidation;
import org.jboss.cache.invalidation.BridgeInvalidationSubscription;
import org.jboss.cache.invalidation.Invalidatable;
import org.jboss.cache.invalidation.InvalidationBridgeListener;
import org.jboss.cache.invalidation.InvalidationGroup;
import org.jboss.cache.invalidation.InvalidationManagerMBean;
import org.jboss.logging.Logger;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;

public class InvalidationManager
extends ServiceMBeanSupport
implements InvalidationManagerMBean {
    public static final String DEFAULT_JMX_SERVICE_NAME = "jboss.cache:service=InvalidationManager";
    public static final String DEFAULT_INVALIDERS_JMX_NAME = "jboss.cache:service=InvalidationGroup";
    protected Hashtable groups = new Hashtable();
    protected Vector bridgeSubscribers = new Vector();
    protected int hashcode = 0;
    protected boolean DEFAULT_TO_ASYNCHRONOUS_MODE = false;

    public void startService() throws Exception {
        this.log.debug((Object)("Starting Invalidation Manager " + this.getServiceName().toString()));
        Registry.bind((Object)this.getServiceName().toString(), (Object)this);
        this.hashcode = this.getServiceName().hashCode();
    }

    public void stopService() {
        this.log.debug((Object)("Stoping Invalidation Manager " + this.getServiceName().toString()));
        Registry.unbind((Object)this.getServiceName().toString());
    }

    public boolean getIsAsynchByDefault() {
        return this.DEFAULT_TO_ASYNCHRONOUS_MODE;
    }

    public void setIsAsynchByDefault(boolean flag) {
        this.DEFAULT_TO_ASYNCHRONOUS_MODE = flag;
    }

    public Collection getInvalidationGroups() {
        return this.groups.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvalidationGroup getInvalidationGroup(String groupName) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            InvalidationGroup group = (InvalidationGroup)this.groups.get(groupName);
            if (group == null) {
                group = this.createGroup(groupName);
            }
            group.addReference();
            return group;
        }
    }

    public synchronized BridgeInvalidationSubscription registerBridgeListener(InvalidationBridgeListener listener) {
        this.log.debug((Object)"Subscribing a new cache-invalidation bridge");
        BridgeInvalidationSubscriptionImpl subs = new BridgeInvalidationSubscriptionImpl(listener);
        Vector<BridgeInvalidationSubscriptionImpl> newVector = new Vector<BridgeInvalidationSubscriptionImpl>(this.bridgeSubscribers);
        newVector.add(subs);
        this.bridgeSubscribers = newVector;
        return subs;
    }

    public void batchInvalidate(BatchInvalidation[] invalidations) {
        this.batchInvalidate(invalidations, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
    }

    public void batchInvalidate(BatchInvalidation[] invalidations, boolean asynchronous) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Batch cache invalidation. Caches concerned: " + invalidations.length));
        }
        this.crossDomainBatchInvalidate(null, invalidations, asynchronous);
    }

    public void invalidateAll(String groupName) {
        this.invalidateAll(groupName, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
    }

    public void invalidateAll(String groupName, boolean async) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Invalidate all for group: " + groupName));
        }
        this.crossDomainInvalidateAll(null, groupName, async);
    }

    public int hashCode() {
        return this.hashcode;
    }

    protected InvalidationGroup createGroup(String groupName) {
        InvalidationGroupImpl group = new InvalidationGroupImpl(groupName);
        this.groups.put(groupName, group);
        try {
            this.log.debug((Object)("Creating and registering a new InvalidationGroup: " + groupName));
            ObjectName groupObjectName = new ObjectName("jboss.cache:service=InvalidationGroup,GroupName=" + groupName);
            this.getServer().registerMBean(group, groupObjectName);
        }
        catch (Exception e) {
            this.log.debug((Object)"Problem while trying to register a new invalidation group in JMX", (Throwable)e);
        }
        this.log.debug((Object)"Informing bridges about new group creation ...");
        for (int i = 0; i < this.bridgeSubscribers.size(); ++i) {
            ((BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i)).groupCreated(groupName);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeGroup(String groupName) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            this.groups.remove(groupName);
            try {
                this.log.debug((Object)("Removing and JMX-unregistering an InvalidationGroup: " + groupName));
                ObjectName groupObjectName = new ObjectName("jboss.cache:service=InvalidationGroup,GroupName=" + groupName);
                this.getServer().unregisterMBean(groupObjectName);
            }
            catch (Exception e) {
                this.log.debug((Object)"Problem while trying to un-register a new invalidation group in JMX", (Throwable)e);
            }
            for (int i = 0; i < this.bridgeSubscribers.size(); ++i) {
                ((BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i)).groupDropped(groupName);
            }
        }
    }

    protected synchronized void unregisterBridgeListener(BridgeInvalidationSubscription bridgeSubscriber) {
        this.log.debug((Object)"Unsubscription of a cache-invalidation bridge");
        Vector newVector = new Vector(this.bridgeSubscribers);
        newVector.remove(bridgeSubscriber);
        this.bridgeSubscribers = newVector;
    }

    protected void doLocalOnlyInvalidation(String groupName, Serializable key, boolean asynchronous) {
        InvalidationGroupImpl group = (InvalidationGroupImpl)this.groups.get(groupName);
        if (group != null) {
            group.localOnlyInvalidate(key, asynchronous);
        }
    }

    protected void doLocalOnlyInvalidations(String groupName, Serializable[] keys, boolean asynchronous) {
        InvalidationGroupImpl group = (InvalidationGroupImpl)this.groups.get(groupName);
        if (group != null) {
            group.localOnlyInvalidate(keys, asynchronous);
        }
    }

    protected void doLocalOnlyInvalidateAll(String groupName, boolean asynchronous) {
        InvalidationGroupImpl group = (InvalidationGroupImpl)this.groups.get(groupName);
        if (group != null) {
            group.localOnlyInvalidateAll();
        }
    }

    protected void doBridgedOnlyInvalidation(BridgeInvalidationSubscriptionImpl exceptSource, String groupName, Serializable key) {
        for (int i = 0; i < this.bridgeSubscribers.size(); ++i) {
            BridgeInvalidationSubscriptionImpl bridge = (BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i);
            if (bridge == exceptSource) continue;
            bridge.bridgedInvalidate(groupName, key, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
        }
    }

    protected void doBridgedOnlyInvalidation(BridgeInvalidationSubscriptionImpl exceptSource, String groupName, Serializable[] keys) {
        for (int i = 0; i < this.bridgeSubscribers.size(); ++i) {
            BridgeInvalidationSubscriptionImpl bridge = (BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i);
            if (bridge == exceptSource) continue;
            bridge.bridgedInvalidate(groupName, keys, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
        }
    }

    protected void doBridgedOnlyInvalidateAll(BridgeInvalidationSubscriptionImpl exceptSource, String groupName) {
        for (int i = 0; i < this.bridgeSubscribers.size(); ++i) {
            BridgeInvalidationSubscriptionImpl bridge = (BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i);
            if (bridge == exceptSource) continue;
            bridge.bridgedInvalidateAll(groupName, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
        }
    }

    protected void localGroupInvalidationEvent(String groupName, Serializable key, boolean asynchronous) {
        for (int i = 0; i < this.bridgeSubscribers.size(); ++i) {
            ((BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i)).bridgedInvalidate(groupName, key, asynchronous);
        }
    }

    protected void localGroupInvalidationsEvent(String groupName, Serializable[] keys, boolean asynchronous) {
        for (int i = 0; i < this.bridgeSubscribers.size(); ++i) {
            ((BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i)).bridgedInvalidate(groupName, keys, asynchronous);
        }
    }

    protected void localGroupInvalidateAllEvent(String groupName, boolean asynchronous) {
        for (int i = 0; i < this.bridgeSubscribers.size(); ++i) {
            ((BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i)).bridgedInvalidateAll(groupName, asynchronous);
        }
    }

    protected void bridgeGroupInvalidationEvent(BridgeInvalidationSubscriptionImpl source, String groupName, Serializable key) {
        this.doBridgedOnlyInvalidation(source, groupName, key);
        this.doLocalOnlyInvalidation(groupName, key, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
    }

    protected void bridgeGroupInvalidationEvent(BridgeInvalidationSubscriptionImpl source, String groupName, Serializable[] keys) {
        this.doBridgedOnlyInvalidation(source, groupName, keys);
        this.doLocalOnlyInvalidation(groupName, (Serializable)keys, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
    }

    protected void bridgeGroupInvalidateAllEvent(BridgeInvalidationSubscriptionImpl source, String groupName) {
        this.doBridgedOnlyInvalidateAll(source, groupName);
        this.doLocalOnlyInvalidateAll(groupName, this.DEFAULT_TO_ASYNCHRONOUS_MODE);
    }

    protected void crossDomainBatchInvalidate(BridgeInvalidationSubscriptionImpl source, BatchInvalidation[] invalidations, boolean asynchronous) {
        int i;
        if (invalidations == null) {
            return;
        }
        for (i = 0; i < invalidations.length; ++i) {
            BatchInvalidation currInvalid = invalidations[i];
            this.doLocalOnlyInvalidations(currInvalid.getInvalidationGroupName(), currInvalid.getIds(), asynchronous);
        }
        for (i = 0; i < this.bridgeSubscribers.size(); ++i) {
            BridgeInvalidationSubscriptionImpl bridge = (BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i);
            if (bridge == source) continue;
            bridge.bridgedBatchInvalidations(invalidations, asynchronous);
        }
    }

    protected void crossDomainInvalidateAll(BridgeInvalidationSubscriptionImpl source, String groupName, boolean asynchronous) {
        this.doLocalOnlyInvalidateAll(groupName, asynchronous);
        for (int i = 0; i < this.bridgeSubscribers.size(); ++i) {
            BridgeInvalidationSubscriptionImpl bridge = (BridgeInvalidationSubscriptionImpl)this.bridgeSubscribers.elementAt(i);
            if (bridge == source) continue;
            bridge.bridgedInvalidateAll(groupName, asynchronous);
        }
    }

    class BridgeInvalidationSubscriptionImpl
    implements BridgeInvalidationSubscription {
        protected InvalidationBridgeListener listener = null;

        public BridgeInvalidationSubscriptionImpl(InvalidationBridgeListener listener) {
            this.listener = listener;
        }

        public void invalidate(String invalidationGroupName, Serializable key) {
            InvalidationManager.this.bridgeGroupInvalidationEvent(this, invalidationGroupName, key);
        }

        public void invalidate(String invalidationGroupName, Serializable[] keys) {
            InvalidationManager.this.bridgeGroupInvalidationEvent(this, invalidationGroupName, keys);
        }

        public void invalidateAll(String groupName) {
            InvalidationManager.this.bridgeGroupInvalidateAllEvent(this, groupName);
        }

        public void batchInvalidate(BatchInvalidation[] invalidations) {
            InvalidationManager.this.crossDomainBatchInvalidate(this, invalidations, InvalidationManager.this.DEFAULT_TO_ASYNCHRONOUS_MODE);
        }

        public void unregister() {
            InvalidationManager.this.unregisterBridgeListener(this);
        }

        protected void bridgedInvalidate(String invalidationGroupName, Serializable key, boolean asynchronous) {
            this.listener.invalidate(invalidationGroupName, key, asynchronous);
        }

        protected void bridgedInvalidate(String invalidationGroupName, Serializable[] keys, boolean asynchronous) {
            this.listener.invalidate(invalidationGroupName, keys, asynchronous);
        }

        protected void bridgedInvalidateAll(String invalidationGroupName, boolean asynchronous) {
            this.listener.invalidateAll(invalidationGroupName, asynchronous);
        }

        protected void bridgedBatchInvalidations(BatchInvalidation[] invalidations, boolean asynchronous) {
            this.listener.batchInvalidate(invalidations, asynchronous);
        }

        protected void groupCreated(String invalidationGroupName) {
            this.listener.newGroupCreated(invalidationGroupName);
        }

        protected void groupDropped(String invalidationGroupName) {
            this.listener.groupIsDropped(invalidationGroupName);
        }
    }

    class InvalidationGroupImpl
    implements InvalidationGroup,
    DynamicMBean {
        protected Logger igLog = null;
        protected String groupName = null;
        protected boolean asynchronous;
        protected HashSet registered;
        protected int counter;

        public int hashCode() {
            return this.groupName.hashCode();
        }

        public String getGroupName() {
            return this.groupName;
        }

        public InvalidationGroupImpl(String groupName) {
            this.asynchronous = InvalidationManager.this.DEFAULT_TO_ASYNCHRONOUS_MODE;
            this.registered = new HashSet();
            this.counter = 0;
            this.groupName = groupName;
            String escapedClass = this.getClass().getName().replace('$', '.');
            this.igLog = Logger.getLogger((String)(escapedClass + "." + groupName));
        }

        public InvalidationManagerMBean getInvalidationManager() {
            return InvalidationManager.this;
        }

        public void invalidate(Serializable key) {
            this.invalidate(key, this.asynchronous);
        }

        public void invalidate(Serializable key, boolean asynchronous) {
            this.localOnlyInvalidate(key, asynchronous);
            InvalidationManager.this.localGroupInvalidationEvent(this.groupName, key, asynchronous);
        }

        public void invalidate(Serializable[] keys) {
            this.invalidate(keys, this.asynchronous);
        }

        public void invalidate(Serializable[] keys, boolean asynchronous) {
            this.localOnlyInvalidate(keys, asynchronous);
            InvalidationManager.this.localGroupInvalidationsEvent(this.groupName, keys, asynchronous);
        }

        public void invalidateAll() {
            this.invalidateAll(this.asynchronous);
        }

        public void invalidateAll(boolean asynchronous) {
            this.localOnlyInvalidateAll();
            InvalidationManager.this.localGroupInvalidateAllEvent(this.groupName, asynchronous);
        }

        public synchronized void register(Invalidatable newRegistered) {
            HashSet<Invalidatable> newlyRegistered = new HashSet<Invalidatable>(this.registered);
            newlyRegistered.add(newRegistered);
            this.registered = newlyRegistered;
        }

        public synchronized void unregister(Invalidatable oldRegistered) {
            HashSet newlyRegistered = new HashSet(this.registered);
            newlyRegistered.remove(oldRegistered);
            this.registered = newlyRegistered;
            this.removeReference();
        }

        public void setAsynchronousInvalidation(boolean async) {
            this.asynchronous = async;
        }

        public boolean getAsynchronousInvalidation() {
            return this.asynchronous;
        }

        public void addReference() {
            ++this.counter;
            this.igLog.debug((Object)("Counter reference value (++): " + this.counter));
        }

        public int getReferenceCount() {
            return this.counter;
        }

        public void removeReference() {
            --this.counter;
            this.igLog.debug((Object)("Counter reference value (--): " + this.counter));
            if (this.counter <= 0) {
                InvalidationManager.this.removeGroup(this.groupName);
            }
        }

        public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if (attribute == null || attribute.equals("")) {
                throw new IllegalArgumentException("null or empty attribute name");
            }
            if (attribute.equals("AsynchronousInvalidation")) {
                return new Boolean(this.asynchronous);
            }
            throw new AttributeNotFoundException(attribute + " is not a known attribute");
        }

        public AttributeList getAttributes(String[] attributes) {
            return null;
        }

        public MBeanInfo getMBeanInfo() {
            MBeanParameterInfo serSimpleParam = new MBeanParameterInfo("key", Serializable.class.getName(), "Primary key to be invalidated");
            MBeanParameterInfo serArrayParam = new MBeanParameterInfo("keys", Serializable[].class.getName(), "Primary keys to be invalidated");
            MBeanParameterInfo asynchParam = new MBeanParameterInfo("asynchronous", Boolean.class.getName(), "Indicates if the invalidation should be asynchronous or must be synchronous");
            MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[]{new MBeanAttributeInfo("AsynchronousInvalidation", Boolean.class.getName(), "Indicates if invalidation, by default, should be done asynchronously", true, true, false)};
            MBeanOperationInfo[] opInfo = new MBeanOperationInfo[]{new MBeanOperationInfo("invalidate", "invalidate a single key using default (a)synchronous behaviour", new MBeanParameterInfo[]{serSimpleParam}, Void.TYPE.getName(), 1), new MBeanOperationInfo("invalidate", "invalidate a single key indicating the (a)synchronous behaviour", new MBeanParameterInfo[]{serSimpleParam, asynchParam}, Void.TYPE.getName(), 1), new MBeanOperationInfo("invalidate", "invalidate multiple keys using default (a)synchronous behaviour", new MBeanParameterInfo[]{serArrayParam}, Void.TYPE.getName(), 1), new MBeanOperationInfo("invalidate", "invalidate multiple keys indicating the (a)synchronous behaviour", new MBeanParameterInfo[]{serArrayParam, asynchParam}, Void.TYPE.getName(), 1), new MBeanOperationInfo("invalidateAll", "invalidate all keys using default (a)synchronous behaviour", new MBeanParameterInfo[0], Void.TYPE.getName(), 1), new MBeanOperationInfo("invalidateAll", "invalidate all keys with specified (a)synchronous behaviour", new MBeanParameterInfo[]{asynchParam}, Void.TYPE.getName(), 1)};
            MBeanNotificationInfo[] notifyInfo = null;
            MBeanConstructorInfo[] ctorInfo = new MBeanConstructorInfo[]{};
            return new MBeanInfo(this.getClass().getName(), "Cache invalidation for group named " + this.groupName, attrInfo, ctorInfo, opInfo, notifyInfo);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            if ("invalidate".equals(actionName)) {
                if (params.length == 1) {
                    if (params[0] instanceof Serializable[]) {
                        this.invalidate((Serializable[])params[0]);
                        return null;
                    } else {
                        if (!(params[0] instanceof Serializable)) throw new IllegalArgumentException("First argument must be Serializable (or array of)");
                        this.invalidate((Serializable)params[0]);
                    }
                    return null;
                } else {
                    if (params.length != 2) throw new IllegalArgumentException("Unknown operation with these parameters: " + actionName);
                    if (params[0] instanceof Serializable[]) {
                        this.invalidate((Serializable[])params[0], (boolean)((Boolean)params[1]));
                        return null;
                    } else {
                        if (!(params[0] instanceof Serializable)) throw new IllegalArgumentException("First argument must be Serializable (or array of)");
                        this.invalidate((Serializable)params[0], (boolean)((Boolean)params[1]));
                    }
                }
                return null;
            } else {
                if (!"invalidateAll".equals(actionName)) throw new IllegalArgumentException("Unknown operation: " + actionName);
                if (params == null || params.length == 0) {
                    this.invalidateAll();
                    return null;
                } else {
                    if (params.length != 1) throw new IllegalArgumentException("invalidateAll can take zero or one parameter but got " + params.length);
                    this.invalidateAll((Boolean)params[1]);
                }
            }
            return null;
        }

        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            Object value;
            String attrName = attribute.getName();
            if (attrName == null || attrName.equals("")) {
                throw new IllegalArgumentException("null or empty attribute name");
            }
            if (attrName.equals("AsynchronousInvalidation")) {
                value = attribute.getValue();
                if (!(value instanceof Boolean)) {
                    throw new InvalidAttributeValueException("Attribute is of boolean type");
                }
            } else {
                throw new AttributeNotFoundException(attrName + " is not a known attribute");
            }
            this.asynchronous = (Boolean)value;
        }

        public AttributeList setAttributes(AttributeList attributes) {
            return null;
        }

        protected void localOnlyInvalidate(Serializable[] keys, boolean asynchronous) {
            for (Invalidatable inv : this.registered) {
                inv.areInvalid(keys);
            }
        }

        protected void localOnlyInvalidate(Serializable key, boolean asynchronous) {
            for (Invalidatable inv : this.registered) {
                inv.isInvalid(key);
            }
        }

        protected void localOnlyInvalidateAll() {
            for (Invalidatable inv : this.registered) {
                inv.invalidateAll();
            }
        }
    }
}

