/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.javaee;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.Ear6xMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEApplicationInformer;
import org.jboss.system.metadata.ServiceDeployment;

public class NamingJavaEEApplicationInformer
implements JavaEEApplicationInformer {
    private static final String[] REQUIRED_ATTACHMENTS = new String[]{JBossAppMetaData.class.getName(), ServiceDeployment.class.getName()};

    public String getApplicationName(DeploymentUnit deploymentUnit) throws IllegalArgumentException {
        if (!this.isJavaEEApplication(deploymentUnit)) {
            return null;
        }
        String explicitAppName = this.getExplicitApplicationName(deploymentUnit);
        if (explicitAppName != null) {
            return explicitAppName;
        }
        String name = deploymentUnit.getSimpleName();
        return name.substring(0, name.length() - 4);
    }

    public boolean isEnterpriseApplicationArchive(DeploymentUnit deploymentUnit) {
        return deploymentUnit.isAttachmentPresent(JBossAppMetaData.class) || this.isTopLevelServiceArchive(deploymentUnit);
    }

    public boolean isJavaEEApplication(DeploymentUnit deploymentUnit) {
        return deploymentUnit.isTopLevel();
    }

    protected boolean isTopLevelServiceArchive(DeploymentUnit deploymentUnit) {
        return deploymentUnit.isTopLevel() && deploymentUnit.isAttachmentPresent(ServiceDeployment.class) && deploymentUnit.getSimpleName().endsWith(".sar");
    }

    public String[] getRequiredAttachments() {
        return REQUIRED_ATTACHMENTS;
    }

    private String getExplicitApplicationName(DeploymentUnit deploymentUnit) {
        Ear6xMetaData ear6x;
        String explicitAppName;
        EarMetaData earMetaData = (EarMetaData)deploymentUnit.getAttachment(EarMetaData.class);
        if (earMetaData != null && earMetaData.isEE6() && earMetaData instanceof Ear6xMetaData && (explicitAppName = (ear6x = (Ear6xMetaData)earMetaData).getApplicationName()) != null && !explicitAppName.trim().isEmpty()) {
            return explicitAppName;
        }
        return null;
    }
}

