/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class SessionIndividualAcknowledgeMessage
extends PacketImpl {
    private long consumerID;
    private long messageID;
    private boolean requiresResponse;

    public SessionIndividualAcknowledgeMessage(long consumerID, long messageID, boolean requiresResponse) {
        super((byte)81);
        this.consumerID = consumerID;
        this.messageID = messageID;
        this.requiresResponse = requiresResponse;
    }

    public SessionIndividualAcknowledgeMessage() {
        super((byte)81);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public long getMessageID() {
        return this.messageID;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeLong(this.messageID);
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.messageID = buffer.readLong();
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SessionIndividualAcknowledgeMessage)) {
            return false;
        }
        SessionIndividualAcknowledgeMessage r = (SessionIndividualAcknowledgeMessage)other;
        return super.equals(other) && this.consumerID == r.consumerID && this.messageID == r.messageID && this.requiresResponse == r.requiresResponse;
    }
}

