/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.postoffice.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.postoffice.AddressManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.postoffice.BindingsFactory;
import org.hornetq.core.postoffice.impl.AddressImpl;

public class SimpleAddressManager
implements AddressManager {
    private static final Logger log = Logger.getLogger(SimpleAddressManager.class);
    private final ConcurrentMap<SimpleString, Bindings> mappings = new ConcurrentHashMap<SimpleString, Bindings>();
    private final ConcurrentMap<SimpleString, Binding> nameMap = new ConcurrentHashMap<SimpleString, Binding>();
    private final BindingsFactory bindingsFactory;

    public SimpleAddressManager(BindingsFactory bindingsFactory) {
        this.bindingsFactory = bindingsFactory;
    }

    @Override
    public boolean addBinding(Binding binding) {
        if (this.nameMap.putIfAbsent(binding.getUniqueName(), binding) != null) {
            throw new IllegalStateException("Binding already exists " + binding);
        }
        return this.addMappingInternal(binding.getAddress(), binding);
    }

    @Override
    public Binding removeBinding(SimpleString uniqueName) {
        Binding binding = (Binding)this.nameMap.remove(uniqueName);
        if (binding == null) {
            return null;
        }
        this.removeBindingInternal(binding.getAddress(), uniqueName);
        return binding;
    }

    @Override
    public Bindings getBindingsForRoutingAddress(SimpleString address) {
        return (Bindings)this.mappings.get(address);
    }

    @Override
    public Binding getBinding(SimpleString bindableName) {
        return (Binding)this.nameMap.get(bindableName);
    }

    @Override
    public Map<SimpleString, Binding> getBindings() {
        return this.nameMap;
    }

    @Override
    public Bindings getMatchingBindings(SimpleString address) {
        AddressImpl add = new AddressImpl(address);
        Bindings bindings = this.bindingsFactory.createBindings();
        for (Binding binding : this.nameMap.values()) {
            AddressImpl addCheck = new AddressImpl(binding.getAddress());
            if (!addCheck.matches(add)) continue;
            bindings.addBinding(binding);
        }
        return bindings;
    }

    @Override
    public void clear() {
        this.nameMap.clear();
        this.mappings.clear();
    }

    protected void removeBindingInternal(SimpleString address, SimpleString bindableName) {
        Bindings bindings = (Bindings)this.mappings.get(address);
        if (bindings != null) {
            this.removeMapping(bindableName, bindings);
            if (bindings.getBindings().isEmpty()) {
                this.mappings.remove(address);
            }
        }
    }

    protected Binding removeMapping(SimpleString bindableName, Bindings bindings) {
        Binding theBinding = null;
        for (Binding binding : bindings.getBindings()) {
            if (!binding.getUniqueName().equals(bindableName)) continue;
            theBinding = binding;
            break;
        }
        if (theBinding == null) {
            throw new IllegalStateException("Cannot find binding " + bindableName);
        }
        bindings.removeBinding(theBinding);
        return theBinding;
    }

    protected boolean addMappingInternal(SimpleString address, Binding binding) {
        Bindings bindings = (Bindings)this.mappings.get(address);
        Bindings prevBindings = null;
        if (bindings == null && (prevBindings = this.mappings.putIfAbsent(address, bindings = this.bindingsFactory.createBindings())) != null) {
            bindings = prevBindings;
        }
        bindings.addBinding(binding);
        return prevBindings != null;
    }
}

