/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.util.ConcurrentWeakKeyHashMap;
import org.infinispan.util.ReflectionUtil;

public class ReflectionCache {
    private final ConcurrentMap<ClassClassKey, List<Method>> methodsWithAnnotationCache = new ConcurrentWeakKeyHashMap<ClassClassKey, List<Method>>();

    public List<Method> getAllMethods(Class type, Class<? extends Annotation> annotationType) {
        ClassClassKey key = new ClassClassKey(type, annotationType);
        List<Method> annotated = (List<Method>)this.methodsWithAnnotationCache.get(key);
        if (annotated != null) {
            return annotated;
        }
        annotated = ReflectionUtil.getAllMethods(type, annotationType);
        this.methodsWithAnnotationCache.putIfAbsent(key, annotated);
        return annotated;
    }

    public void stop() {
        this.methodsWithAnnotationCache.clear();
    }

    private static class ClassClassKey {
        private final Class type;
        private final Class otherType;

        public ClassClassKey(Class type, Class annotationType) {
            this.type = type;
            this.otherType = annotationType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassClassKey that = (ClassClassKey)o;
            if (this.otherType != null ? !this.otherType.equals(that.otherType) : that.otherType != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.otherType != null ? this.otherType.hashCode() : 0);
            return result;
        }
    }
}

