/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.infinispan.distribution.ch.AbstractWheelConsistentHash;
import org.infinispan.marshall.Marshallable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Marshallable(externalizer=Externalizer.class, id=51)
public class DefaultConsistentHash
extends AbstractWheelConsistentHash {
    private static Log log = LogFactory.getLog(DefaultConsistentHash.class);

    @Override
    public List<Address> locate(Object key, int replCount) {
        int hash = this.getNormalizedHash(key);
        int numCopiesToFind = Math.min(replCount, this.addresses.size());
        ArrayList<Address> owners = new ArrayList<Address>(numCopiesToFind);
        SortedMap candidates = this.positions.tailMap(hash);
        int numOwnersFound = 0;
        for (Address a : candidates.values()) {
            if (numOwnersFound >= numCopiesToFind) break;
            owners.add(a);
            ++numOwnersFound;
        }
        if (numOwnersFound < numCopiesToFind) {
            for (Address a : this.positions.values()) {
                if (numOwnersFound >= numCopiesToFind) break;
                owners.add(a);
                ++numOwnersFound;
            }
        }
        return owners;
    }

    @Override
    public boolean isKeyLocalToAddress(Address target, Object key, int replCount) {
        int hash = this.getNormalizedHash(key);
        int numCopiesToFind = Math.min(replCount, this.addresses.size());
        SortedMap candidates = this.positions.tailMap(hash);
        int nodesTested = 0;
        for (Address a : candidates.values()) {
            if (nodesTested >= numCopiesToFind) break;
            if (a.equals(target)) {
                return true;
            }
            ++nodesTested;
        }
        if (nodesTested < numCopiesToFind) {
            for (Address a : this.positions.values()) {
                if (nodesTested >= numCopiesToFind) break;
                if (a.equals(target)) {
                    return true;
                }
                ++nodesTested;
            }
        }
        return false;
    }

    public int getDistance(Address a1, Address a2) {
        if (a1 == null || a2 == null) {
            throw new NullPointerException("Cannot deal with nulls as parameters!");
        }
        int p1 = this.addresses.indexOf(a1);
        if (p1 < 0) {
            return -1;
        }
        int p2 = this.addresses.indexOf(a2);
        if (p2 < 0) {
            return -1;
        }
        if (p1 <= p2) {
            return p2 - p1;
        }
        return this.addresses.size() - (p1 - p2);
    }

    public boolean isAdjacent(Address a1, Address a2) {
        int distance = this.getDistance(a1, a2);
        return distance == 1 || distance == this.addresses.size() - 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConsistentHash that = (DefaultConsistentHash)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        return !(this.positions != null ? !this.positions.equals(that.positions) : that.positions != null);
    }

    public int hashCode() {
        int result = this.addresses != null ? this.addresses.hashCode() : 0;
        result = 31 * result + (this.positions != null ? this.positions.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "DefaultConsistentHash{addresses =" + this.positions + ", hash space =" + 10240 + '}';
    }

    public List<Address> getAddressOnTheWheel() {
        return this.addresses;
    }

    @Override
    public List<Address> getStateProvidersOnJoin(Address self, int replCount) {
        LinkedList<Address> l = new LinkedList<Address>();
        List<Address> caches = this.getCaches();
        int selfIdx = caches.indexOf(self);
        if (selfIdx >= replCount - 1) {
            l.addAll(caches.subList(selfIdx - replCount + 1, selfIdx));
        } else {
            l.addAll(caches.subList(0, selfIdx));
            int alreadyCollected = l.size();
            l.addAll(caches.subList(caches.size() - replCount + 1 + alreadyCollected, caches.size()));
        }
        Address plusOne = selfIdx == caches.size() - 1 ? caches.get(0) : caches.get(selfIdx + 1);
        if (!l.contains(plusOne)) {
            l.add(plusOne);
        }
        return l;
    }

    @Override
    public List<Address> getStateProvidersOnLeave(Address leaver, int replCount) {
        if (log.isTraceEnabled()) {
            log.trace("List of addresses is: " + this.addresses + ". leaver is: " + leaver);
        }
        HashSet<Address> holders = new HashSet<Address>();
        for (Address address : this.addresses) {
            if (this.isAdjacent(leaver, address)) {
                holders.add(address);
                if (!log.isTraceEnabled()) continue;
                log.trace(address + " is state holder");
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace(address + " NOT state holder");
        }
        return new ArrayList<Address>(holders);
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            DefaultConsistentHash dch = (DefaultConsistentHash)subject;
            output.writeObject(dch.addresses);
            output.writeObject(dch.positions);
            output.writeObject(dch.addressToHashIds);
        }

        @Override
        public Object readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            DefaultConsistentHash dch = new DefaultConsistentHash();
            dch.addresses = (ArrayList)unmarshaller.readObject();
            dch.positions = (SortedMap)unmarshaller.readObject();
            dch.addressToHashIds = (Map)unmarshaller.readObject();
            return dch;
        }
    }
}

