/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.mcint.beans.metadata.plugins;

import java.util.Iterator;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.jpa.spi.PersistenceUnit;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.TypeInfo;

public class PersistenceUnitValueMetaData
extends AbstractValueMetaData {
    private static final long serialVersionUID = 1L;
    private MainDeployer mainDeployer;
    private MainDeployerStructure mainDeployerStructure;
    private PersistenceUnitDependencyResolver resolver;
    private String persistenceUnitName;
    private KernelControllerContext context;

    public PersistenceUnitValueMetaData(MainDeployer mainDeployer, MainDeployerStructure mainDeployerStructure, PersistenceUnitDependencyResolver resolver, String persistenceUnitName) {
        assert (mainDeployer != null) : "mainDeployer is null";
        assert (mainDeployerStructure != null) : "mainDeployerStructure is null";
        assert (resolver != null) : "resolver is null";
        this.mainDeployer = mainDeployer;
        this.mainDeployerStructure = mainDeployerStructure;
        this.resolver = resolver;
        this.persistenceUnitName = persistenceUnitName;
    }

    public void describeVisit(MetaDataVisitor visitor) {
        Object name = this.context.getName();
        String iDependOn = this.getPersistenceUnitBeanName();
        this.log.info((Object)("iDependOn " + iDependOn));
        ControllerState whenRequired = visitor.getContextState();
        ControllerState dependentState = ControllerState.INSTALLED;
        AbstractDependencyItem dependency = new AbstractDependencyItem(name, (Object)iDependOn, whenRequired, dependentState);
        visitor.addDependency((DependencyItem)dependency);
        super.describeVisit(visitor);
    }

    private DeploymentUnit findBean(DeploymentUnit deploymentUnit, String contextName) {
        DeploymentUnit result;
        if (deploymentUnit == null) {
            return null;
        }
        BeanMetaData bmd = (BeanMetaData)deploymentUnit.getAttachment(BeanMetaData.class);
        if (bmd != null && bmd.getName().equals(contextName)) {
            return deploymentUnit;
        }
        for (DeploymentUnit component : deploymentUnit.getComponents()) {
            result = this.findBean(component, contextName);
            if (result == null) continue;
            return deploymentUnit;
        }
        for (DeploymentUnit child : deploymentUnit.getChildren()) {
            result = this.findBean(child, contextName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private String getPersistenceUnitBeanName() {
        Deployment deployment;
        String name;
        String contextName = (String)this.context.getName();
        DeploymentUnit deploymentUnit = null;
        Iterator i$ = this.mainDeployer.getTopLevel().iterator();
        while (i$.hasNext() && ((deploymentUnit = this.mainDeployerStructure.getDeploymentUnit(name = (deployment = (Deployment)i$.next()).getName())) == null || (deploymentUnit = this.findBean(deploymentUnit, contextName)) == null)) {
        }
        if (deploymentUnit == null) {
            throw new IllegalStateException("@PersistenceUnit can only be used within a regular deployment unit");
        }
        String persistenceUnitBeanName = this.resolver.resolvePersistenceUnitSupplier(deploymentUnit, this.persistenceUnitName);
        return persistenceUnitBeanName;
    }

    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        String persistenceUnitBeanName = this.getPersistenceUnitBeanName();
        PersistenceUnit pu = (PersistenceUnit)this.context.getController().getContext((Object)persistenceUnitBeanName, ControllerState.INSTALLED).getTarget();
        return pu.getContainerEntityManagerFactory();
    }

    public void initialVisit(MetaDataVisitor visitor) {
        this.context = visitor.getControllerContext();
        super.initialVisit(visitor);
    }
}

