/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.deployers;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.deployers.Ejb3MetadataProcessingDeployer;
import org.jboss.ejb3.nointerface.impl.jndi.AbstractNoInterfaceViewBinder;
import org.jboss.ejb3.nointerface.impl.jndi.SessionlessBeanNoInterfaceViewBinder;
import org.jboss.ejb3.nointerface.impl.jndi.StatefulBeanNoInterfaceViewBinder;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.JNDIPolicyBasedSessionBean31JNDINameResolver;

public class EJB3NoInterfaceDeployer
extends AbstractDeployer {
    private static Logger logger = Logger.getLogger(EJB3NoInterfaceDeployer.class);
    private static final String INPUT = Ejb3MetadataProcessingDeployer.OUTPUT;

    public EJB3NoInterfaceDeployer() {
        this.setStage(DeploymentStages.REAL);
        this.setInput(JBossMetaData.class);
        this.addInput(INPUT);
        this.addOutput(BeanMetaData.class);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        JBossMetaData metaData;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Deploying unit " + unit.getName()));
        }
        if ((metaData = (JBossMetaData)unit.getAttachment(INPUT, JBossMetaData.class)) == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("No JBossMetadata for unit : " + unit.getName()));
            }
            return;
        }
        JBossEnterpriseBeansMetaData beans = metaData.getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData bean : beans) {
            if (!bean.isSession()) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Found bean of type session: " + bean.getEjbClass() + " in unit " + unit.getName()));
            }
            if (!(bean instanceof JBossSessionBean31MetaData)) continue;
            this.deploy(unit, (JBossSessionBean31MetaData)bean);
        }
    }

    private void deploy(DeploymentUnit unit, JBossSessionBean31MetaData sessionBeanMetaData) throws DeploymentException {
        try {
            if (!sessionBeanMetaData.isNoInterfaceBean()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Bean class " + sessionBeanMetaData.getEjbClass() + " is not eligible for no-interface view"));
                }
                return;
            }
            Class<?> beanClass = Class.forName(sessionBeanMetaData.getEjbClass(), false, unit.getClassLoader());
            this.createAndAttachNoInterfaceViewBinder(unit, beanClass, sessionBeanMetaData);
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException((String)("Could not create no-interface view for " + sessionBeanMetaData.getEjbClass() + " in unit " + unit.getName()), (Throwable)t);
        }
    }

    public void undeploy(DeploymentUnit unit, JBossMetaData deployment) {
    }

    private void createAndAttachNoInterfaceViewBinder(DeploymentUnit unit, Class<?> beanClass, JBossSessionBean31MetaData sessionBean) {
        InitialContext initCtx;
        try {
            initCtx = new InitialContext();
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
        JNDIPolicyBasedSessionBean31JNDINameResolver jndiNameResolver = new JNDIPolicyBasedSessionBean31JNDINameResolver();
        String jndiName = jndiNameResolver.resolveNoInterfaceJNDIName(sessionBean);
        AbstractNoInterfaceViewBinder binder = null;
        binder = sessionBean.isStateful() ? new StatefulBeanNoInterfaceViewBinder(initCtx, jndiName, beanClass, sessionBean) : new SessionlessBeanNoInterfaceViewBinder(initCtx, jndiName, beanClass, sessionBean);
        String containerName = sessionBean.getContainerName();
        String binderName = containerName + ",type=nointerface-view-jndi-binder";
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)binderName, (String)binder.getClass().getName());
        builder.setConstructorValue((Object)binder);
        builder.addSupply((Object)("jndi:" + jndiName));
        AbstractInjectionValueMetaData injectMetaData = new AbstractInjectionValueMetaData((Object)containerName);
        injectMetaData.setDependentState(ControllerState.INSTALLED);
        injectMetaData.setFromContext(FromContext.CONTEXT);
        builder.addPropertyMetaData("endpointContext", (ValueMetaData)injectMetaData);
        if (unit.isComponent()) {
            unit.getParent().addAttachment(BeanMetaData.class + ":" + binderName, (Object)builder.getBeanMetaData());
        } else {
            unit.addAttachment(BeanMetaData.class + ":" + binderName, (Object)builder.getBeanMetaData());
        }
        logger.debug((Object)("No-interface JNDI binder for container " + containerName + " has been created and added to the deployment unit " + unit));
    }
}

