/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.tools;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.profileservice.profile.metadata.plugin.HotDeploymentProfileMetaData;
import org.jboss.profileservice.profile.metadata.plugin.PropertyProfileSourceMetaData;
import org.jboss.profileservice.profile.metadata.plugin.ScanPeriod;
import org.jboss.profileservice.repository.artifact.ArtifactRepositoryManager;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.action.ActionController;
import org.jboss.profileservice.spi.managed.ManagedProfile;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.vfs.util.PathTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServiceToolsFacade {
    private static final String TOOLS_PREFIX = "JBossTools-";
    private int scanPeriod = 5;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private ActionController actionController;
    private ProfileService profileService;
    private ArtifactRepositoryManager repositoryManager;
    private final Map<URI, ProfileKey> profiles = new HashMap<URI, ProfileKey>();

    public int getScanPeriod() {
        return this.scanPeriod;
    }

    public void setScanPeriod(int scanPeriod) {
        this.scanPeriod = scanPeriod;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public ArtifactRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setRepositoryManager(ArtifactRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public ActionController getActionController() {
        return this.actionController;
    }

    public void setActionController(ActionController actionController) {
        this.actionController = actionController;
    }

    public void start() {
        if (this.profileService == null) {
            throw new IllegalStateException("null profile service");
        }
        if (this.repositoryManager == null) {
            throw new IllegalStateException("null repository manager");
        }
        if (this.actionController == null) {
            throw new IllegalStateException("null action controller");
        }
    }

    public void stop() {
        Collection<ProfileKey> profiles = this.getRegisteredProfiles();
        for (ProfileKey key : profiles) {
            try {
                this.profileService.deactivateProfile(key);
                this.profileService.unregisterProfile(key);
            }
            catch (NoSuchProfileException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addURI(URI deploymentURI) {
        Map<URI, ProfileKey> map = this.profiles;
        synchronized (map) {
            if (this.profiles.containsKey(deploymentURI)) {
                return;
            }
            if (this.managesLocation(deploymentURI)) {
                return;
            }
            try {
                ProfileKey key = this.profileService.registerProfile(this.createProfileMetaData(deploymentURI));
                this.profiles.put(deploymentURI, key);
                this.profileService.activateProfile(key);
                this.profileService.validateProfile(key);
            }
            catch (Exception e) {
                new RuntimeException("failed add deployment uri", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeURI(URI deploymentURI) {
        Map<URI, ProfileKey> map = this.profiles;
        synchronized (map) {
            ProfileKey key = this.profiles.remove(deploymentURI);
            if (key != null) {
                try {
                    this.profileService.deactivateProfile(key);
                    this.profileService.unregisterProfile(key);
                }
                catch (NoSuchProfileException ignore) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ProfileKey> getRegisteredProfiles() {
        Map<URI, ProfileKey> map = this.profiles;
        synchronized (map) {
            return this.profiles.values();
        }
    }

    public boolean managesURI(URI uri) {
        return this.managesLocation(uri);
    }

    public String[] listDeployedURLs() {
        HashSet names = new HashSet();
        for (ProfileKey key : this.actionController.getActiveProfiles()) {
            ManagedProfile managed = this.actionController.getManagedProfile(key);
            Profile profile = managed.getProfile();
            Set deploymentNames = profile.getDeploymentNames();
            if (deploymentNames == null || deploymentNames.isEmpty()) continue;
            names.addAll(deploymentNames);
        }
        return names.toArray(new String[names.size()]);
    }

    protected boolean managesLocation(URI deploymentURI) {
        for (ArtifactRepository repository : this.repositoryManager.getRepositories()) {
            URI artifactRepositoryURI = repository.getRepositoryURI();
            if (!this.isRelative(artifactRepositoryURI.getPath(), deploymentURI.getPath())) continue;
            return true;
        }
        return false;
    }

    protected boolean isRelative(String root, String relative) {
        Iterator roots = PathTokenizer.getTokens((String)root).iterator();
        Iterator relatives = PathTokenizer.getTokens((String)relative).iterator();
        while (roots.hasNext()) {
            String o;
            if (!relatives.hasNext()) {
                return true;
            }
            String r = (String)roots.next();
            if (r.equals(o = (String)relatives.next())) continue;
            return false;
        }
        return true;
    }

    protected ProfileMetaData createProfileMetaData(URI uri) {
        HotDeploymentProfileMetaData profile = new HotDeploymentProfileMetaData();
        profile.setName(this.createProfileName(uri));
        profile.setSource(this.createSource(uri));
        profile.setScanPeriod(this.createScannerConfiguration());
        return profile;
    }

    protected String createProfileName(URI uri) {
        return TOOLS_PREFIX + uri.hashCode();
    }

    protected PropertyProfileSourceMetaData createSource(URI uri) {
        return new PropertyProfileSourceMetaData(uri.toString());
    }

    protected ScanPeriod createScannerConfiguration() {
        ScanPeriod configuration = new ScanPeriod();
        configuration.setScanPeriod(this.getScanPeriod());
        configuration.setStartAutomatically(true);
        configuration.setTimeUnit(this.getTimeUnit());
        configuration.setDisabled(false);
        return configuration;
    }
}

