/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

class AutoUnmounter {
    private Map<String, Closeable> mounts = new ConcurrentHashMap<String, Closeable>();
    private VirtualFile originals = VFS.getChild((String)"/profileservice/originals/");

    AutoUnmounter() {
    }

    VirtualFile backup(String profileName, String name, VirtualFile original) throws IOException {
        File realFile = original.getPhysicalFile();
        String hash = Integer.toHexString(realFile.toURI().hashCode());
        VirtualFile backup = this.originals.getChild(profileName).getChild(hash + realFile.getName());
        Closeable closeable = VFS.mountReal((File)realFile, (VirtualFile)backup);
        this.mounts.put(name, closeable);
        return backup;
    }

    void cleanup(String name) throws IOException {
        Closeable closeable = this.mounts.remove(name);
        if (closeable != null) {
            closeable.close();
        }
    }
}

