/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.deployers;

import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.deployment.ProfileDeployerPlugin;
import org.jboss.profileservice.deployment.ProfileDeployerPluginRegistry;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.deployers.VDFDeploymentBuilder;

public class MainDeployerPlugin
implements ProfileDeployerPlugin {
    private final VDFDeploymentBuilder deploymentBuilder = VDFDeploymentBuilder.getInstance();
    private final MainDeployer deployer;
    private final ProfileDeployerPluginRegistry registry;

    public MainDeployerPlugin(MainDeployer deployer, ProfileDeployerPluginRegistry registry) {
        if (deployer == null) {
            throw new IllegalArgumentException("null deployer");
        }
        this.deployer = deployer;
        this.registry = registry;
    }

    public void start() {
        this.registry.setDefaultPlugin((ProfileDeployerPlugin)this);
    }

    public void stop() {
        this.registry.removeDefaultPlugin();
    }

    public void addDeployment(ProfileKey key, ProfileDeployment deployment) throws Exception {
        if (deployment == null) {
            throw new IllegalArgumentException("null profile deployment");
        }
        Deployment d = this.createDeployment(key, deployment);
        this.deployer.addDeployment(d);
    }

    public void checkComplete(String ... names) throws Exception {
        this.deployer.checkComplete(names);
    }

    public void checkComplete() throws Exception {
        this.deployer.checkComplete();
    }

    public ManagedDeployment getManagedDeployment(ProfileDeployment deployment) throws Exception {
        if (deployment == null) {
            throw new IllegalArgumentException("null profile deployment");
        }
        return this.deployer.getManagedDeployment(deployment.getName());
    }

    public boolean isSupportRedeployment() {
        return true;
    }

    public void process() {
        this.deployer.process();
    }

    public void removeDeployment(ProfileKey key, ProfileDeployment deployment) throws Exception {
        if (deployment == null) {
            throw new IllegalArgumentException("null profile deployment");
        }
        this.deployer.removeDeployment(deployment.getName());
    }

    public void prepareShutdown() {
        this.deployer.prepareShutdown();
    }

    public void shutdown() {
        this.deployer.shutdown();
    }

    Deployment createDeployment(ProfileKey key, ProfileDeployment deployment) throws Exception {
        return this.deploymentBuilder.createDeployment(key, deployment);
    }
}

