/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.hierarchy.plugins;

import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.scanning.hierarchy.plugins.HierarchyIndexImpl;
import org.jboss.scanning.hierarchy.plugins.HierarchyTypeVisitor;
import org.jboss.scanning.hierarchy.spi.HierarchyIndex;
import org.jboss.scanning.plugins.helpers.ClassResourceOwnerFinder;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.visitor.ErrorHandler;
import org.jboss.scanning.plugins.visitor.IntrospectionReflectProvider;
import org.jboss.scanning.plugins.visitor.ReflectProvider;
import org.jboss.scanning.spi.helpers.AbstractClassLoadingScanningPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyIndexScanningPlugin
extends AbstractClassLoadingScanningPlugin<HierarchyIndexImpl, HierarchyIndex> {
    private final HierarchyIndexImpl hierarchy;
    private final HierarchyTypeVisitor visitor;

    public HierarchyIndexScanningPlugin(ClassLoader cl) {
        this(IntrospectionReflectProvider.INSTANCE, ClassResourceOwnerFinder.INSTANCE, cl, null);
    }

    public HierarchyIndexScanningPlugin(ReflectProvider provider, ResourceOwnerFinder finder, ClassLoader cl, ErrorHandler handler) {
        this.hierarchy = new HierarchyIndexImpl(cl);
        this.visitor = new HierarchyTypeVisitor(provider, finder, this.hierarchy);
        this.visitor.setErrorHandler(handler);
    }

    protected HierarchyIndexImpl doCreateHandle() {
        return this.hierarchy;
    }

    protected ClassLoader getClassLoader() {
        return this.hierarchy.getClassLoader();
    }

    public void cleanupHandle(HierarchyIndex handle) {
        if (handle instanceof HierarchyIndexImpl) {
            ((HierarchyIndexImpl)HierarchyIndexImpl.class.cast(handle)).cleanup();
        }
    }

    public Class<HierarchyIndex> getHandleInterface() {
        return HierarchyIndex.class;
    }

    public ResourceFilter getFilter() {
        return ClassFilter.INSTANCE;
    }

    public void visit(ResourceContext resource) {
        this.visitor.visit(resource);
    }
}

